/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.throwables;

import com.toma.pubgmc.common.blocks.BlockWindow;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketSyncEntity;
import com.toma.pubgmc.util.PUBGMCUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityThrowableExplodeable
extends Entity
implements IEntityAdditionalSpawnData {
    public static final float AIR_DRAG_MODIFIER = 0.98f;
    public static final float GROUND_DRAG_MODIFIER = 0.7f;
    public static final float BOUNCE_MODIFIER = 0.8f;
    public int fuse;
    public float rotation;
    public float lastRotation;
    public int timesBounced = 0;
    public boolean isFrozen = false;

    public EntityThrowableExplodeable(World world) {
        this(world, null, EnumEntityThrowState.FORCED);
    }

    public EntityThrowableExplodeable(World world, EntityLivingBase thrower, EnumEntityThrowState state) {
        this(world, thrower, state, state == EnumEntityThrowState.FORCED ? 1 : 100);
    }

    public EntityThrowableExplodeable(World world, EntityLivingBase thrower, EnumEntityThrowState state, int time) {
        super(world);
        this.func_70105_a(0.2f, 0.2f);
        if (thrower != null) {
            this.func_70107_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v);
        }
        this.fuse = time;
        this.setInitialMotion(state, thrower);
    }

    public abstract void onExplode();

    public void func_70071_h_() {
        Vec3d to;
        Vec3d from;
        RayTraceResult rayTraceResult;
        --this.fuse;
        if (this.fuse < 0) {
            this.onExplode();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double prevMotionX = this.field_70159_w;
        double prevMotionY = this.field_70181_x;
        double prevMotionZ = this.field_70179_y;
        if (!this.field_70170_p.field_72995_K && (rayTraceResult = this.field_70170_p.func_147447_a(from = PUBGMCUtil.getPositionVec(this), to = PUBGMCUtil.getMotionVec(this), false, true, false)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.onCollide(from, to, rayTraceResult);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70159_w != prevMotionX) {
            this.field_70159_w = (double)-0.8f * prevMotionX;
            this.onGrenadeBounce(BounceAxis.X);
        }
        if (this.field_70181_x != prevMotionY) {
            this.field_70181_x = (double)-0.8f * prevMotionY;
            this.onGrenadeBounce(BounceAxis.Y);
        }
        if (this.field_70179_y != prevMotionZ) {
            this.field_70179_y = (double)-0.8f * prevMotionZ;
            this.onGrenadeBounce(BounceAxis.Z);
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.039;
        }
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70181_x *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
        this.lastRotation = this.rotation;
        if (this.field_70170_p.field_72995_K && !this.field_70122_E && this.field_70159_w != 0.0 && this.field_70181_x != 0.0 && this.field_70179_y != 0.0) {
            this.rotation += 45.0f;
        }
        this.onThrowableTick();
    }

    public final void onCollide(Vec3d from, Vec3d to, RayTraceResult result) {
        BlockPos pos = result.func_178782_a();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("weaponGriefing");
        if (flag) {
            RayTraceResult rayTraceResult;
            boolean hasBrokenGlass = false;
            if (state.func_177230_c() instanceof BlockWindow) {
                BlockWindow window = (BlockWindow)state.func_177230_c();
                boolean isBroken = (Boolean)state.func_177229_b((IProperty)BlockWindow.BROKEN);
                if (!isBroken) {
                    window.breakWindow(state, pos, this.field_70170_p);
                    hasBrokenGlass = true;
                }
            } else if (state.func_185904_a() == Material.field_151592_s) {
                this.field_70170_p.func_175655_b(pos, false);
                hasBrokenGlass = true;
            }
            if (hasBrokenGlass && (rayTraceResult = this.field_70170_p.func_147447_a(from, to, false, true, false)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.onCollide(from, to, rayTraceResult);
            }
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public void onThrowableTick() {
    }

    public void bounce() {
    }

    public boolean canBounce() {
        return true;
    }

    public final boolean isFirstBounce() {
        return this.timesBounced == 1;
    }

    public void writeSpawnData(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.func_189511_e(new NBTTagCompound()));
    }

    public void readSpawnData(ByteBuf buf) {
        this.func_70020_e(ByteBufUtils.readTag((ByteBuf)buf));
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("fuse", this.fuse);
        compound.func_74757_a("frozen", this.isFrozen);
        compound.func_74768_a("timesBounced", this.timesBounced);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.fuse = compound.func_74762_e("fuse");
        this.isFrozen = compound.func_74767_n("frozen");
        this.timesBounced = compound.func_74762_e("timesBounced");
    }

    protected void onEntityFrozen() {
        PacketHandler.sendToAllTracking(new PacketSyncEntity(this), this);
    }

    private void setInitialMotion(EnumEntityThrowState state, EntityLivingBase thrower) {
        float modifier;
        if (thrower == null) {
            return;
        }
        int i = state.ordinal();
        float sprintModifier = 1.25f;
        float f = i == 2 ? 0.0f : (modifier = i == 1 ? 0.6f : 1.4f);
        if (thrower.func_70051_ag()) {
            modifier *= sprintModifier;
        }
        Vec3d viewVec = thrower.func_70040_Z();
        this.field_70159_w = viewVec.field_72450_a * (double)modifier;
        this.field_70181_x = viewVec.field_72448_b * (double)modifier / (double)sprintModifier;
        this.field_70179_y = viewVec.field_72449_c * (double)modifier;
    }

    private void freezeEntity() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (this.isFrozen) {
            return;
        }
        this.isFrozen = true;
        this.onEntityFrozen();
    }

    private void onGrenadeBounce(BounceAxis axis) {
        if (Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) >= 0.2) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187677_b, SoundCategory.MASTER, 1.0f, 1.8f);
        }
        ++this.timesBounced;
        if (!this.canBounce()) {
            this.freezeEntity();
        }
        this.bounce();
    }

    public static enum BounceAxis {
        X,
        Y,
        Z;

    }

    public static enum EnumEntityThrowState {
        LONG,
        SHORT,
        FORCED;

    }
}

