/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.items;

import com.toma.pubgmc.PMCTabs;
import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.entity.throwables.EntityFlashBang;
import com.toma.pubgmc.common.entity.throwables.EntityFragGrenade;
import com.toma.pubgmc.common.entity.throwables.EntityMolotov;
import com.toma.pubgmc.common.entity.throwables.EntitySmokeGrenade;
import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import com.toma.pubgmc.common.items.PMCItem;
import com.toma.pubgmc.util.game.loot.LootManager;
import com.toma.pubgmc.util.game.loot.LootType;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemExplodeable
extends PMCItem {
    private final int maxFuse;
    private final ExplodeableItemAction explodeableItemAction;
    private String[] description;

    public ItemExplodeable(String name, int maxFuse, ExplodeableItemAction action) {
        super(name);
        this.maxFuse = maxFuse;
        this.explodeableItemAction = action;
        this.func_77625_d(1);
        this.func_77637_a(PMCTabs.TAB_GUNS);
        LootManager.register(LootType.AMMO, new LootManager.LootEntry(this, 15, false));
    }

    public ItemExplodeable addAditionalDescription(String ... description) {
        this.description = description;
        return this;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void startCooking(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            this.attachNBT(stack, player);
        }
        stack.func_77978_p().func_74757_a("isCooking", true);
        boolean cooking = this.isCooking(stack);
    }

    public boolean isCooking(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("isCooking");
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!stack.func_77942_o()) {
                this.attachNBT(stack, player);
            }
            this.explodeableItemAction.onRemoveFromInventory(stack, player.field_70170_p, player, this.maxFuse - this.getFuseTime(stack), EntityThrowableExplodeable.EnumEntityThrowState.SHORT);
            player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
            player.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 1.0f);
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (!stack.func_77942_o()) {
                this.attachNBT(stack, playerIn);
            }
            if (this.maxFuse > 0 && !this.isCooking(stack)) {
                stack.func_77978_p().func_74757_a("isCooking", true);
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187750_dc, SoundCategory.MASTER, 1.0f, 1.0f);
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            this.explodeableItemAction.onRemoveFromInventory(stack, worldIn, playerIn, this.maxFuse - this.getFuseTime(stack), EntityThrowableExplodeable.EnumEntityThrowState.LONG);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.MASTER, 1.0f, 1.0f);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        if (!worldIn.field_72995_K && this.isCooking(stack)) {
            int timeLeft = this.maxFuse - this.getFuseTime(stack);
            if (timeLeft < 0) {
                this.explodeableItemAction.onRemoveFromInventory(stack, worldIn, (EntityPlayer)entityIn, timeLeft, EntityThrowableExplodeable.EnumEntityThrowState.FORCED);
                ((EntityPlayer)entityIn).field_71071_by.func_70304_b(itemSlot);
                return;
            }
            stack.func_77978_p().func_74768_a("currentFuse", this.getFuseTime(stack) + 1);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Right-click: Long throw");
        tooltip.add("Left-click: Short throw");
        if (this.maxFuse > 0) {
            tooltip.add("Fuse: " + this.maxFuse);
        }
        if (this.description != null) {
            Collections.addAll(tooltip, this.description);
        }
    }

    public ExplodeableItemAction getExplodeableItemAction() {
        return this.explodeableItemAction;
    }

    public int getMaxFuse() {
        return this.maxFuse;
    }

    private void attachNBT(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("currentFuse", 0);
        nbt.func_74757_a("isCooking", false);
        nbt.func_74778_a("ownerID", player.func_110124_au().toString());
        stack.func_77982_d(nbt);
    }

    public int getFuseTime(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("currentFuse");
    }

    public static class Helper {
        public static void onFragRemoved(ItemStack stack, World world, EntityPlayer player, int timeLeft, EntityThrowableExplodeable.EnumEntityThrowState state) {
            if (Helper.failedNBTCheck(stack)) {
                Pubgmc.logger.fatal("Attempted to use {} with invalid NBT data!", stack.func_77973_b().getClass());
                return;
            }
            if (!world.field_72995_K) {
                EntityFragGrenade grenade = new EntityFragGrenade(world, (EntityLivingBase)player, state, timeLeft);
                world.func_72838_d((Entity)grenade);
            }
        }

        public static void onSmokeRemoved(ItemStack stack, World world, EntityPlayer player, int timeLeft, EntityThrowableExplodeable.EnumEntityThrowState state) {
            if (Helper.failedNBTCheck(stack)) {
                Pubgmc.logger.fatal("Attempted to use {} with invalid NBT data!", stack.func_77973_b().getClass());
                return;
            }
            if (!world.field_72995_K) {
                EntitySmokeGrenade smokeGrenade = new EntitySmokeGrenade(world, (EntityLivingBase)player, state, timeLeft);
                world.func_72838_d((Entity)smokeGrenade);
            }
        }

        public static void onMolotovRemoved(ItemStack stack, World world, EntityPlayer player, int timeLeft, EntityThrowableExplodeable.EnumEntityThrowState state) {
            if (Helper.failedNBTCheck(stack)) {
                Pubgmc.logger.fatal("Attempted to use {} with invalid NBT data!", stack.func_77973_b().getClass());
                return;
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityMolotov(world, (EntityLivingBase)player, state));
            }
        }

        public static void onFlashBangRemoved(ItemStack stack, World world, EntityPlayer player, int timeLeft, EntityThrowableExplodeable.EnumEntityThrowState state) {
            if (Helper.failedNBTCheck(stack)) {
                Pubgmc.logger.fatal("Attempted to use {} with invalid NBT data!", stack.func_77973_b().getClass());
                return;
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityFlashBang(world, (EntityLivingBase)player, state, timeLeft));
            }
        }

        private static boolean failedNBTCheck(ItemStack stack) {
            return !(stack.func_77973_b() instanceof ItemExplodeable) || stack.func_77942_o() && !stack.func_77978_p().func_74764_b("ownerID");
        }
    }

    @FunctionalInterface
    public static interface ExplodeableItemAction {
        public void onRemoveFromInventory(ItemStack var1, World var2, EntityPlayer var3, int var4, EntityThrowableExplodeable.EnumEntityThrowState var5);
    }
}

