/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.items.guns;

import com.toma.pubgmc.DevUtil;
import com.toma.pubgmc.PMCTabs;
import com.toma.pubgmc.client.models.ModelGun;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.EntityBullet;
import com.toma.pubgmc.common.items.ItemAmmo;
import com.toma.pubgmc.common.items.PMCItem;
import com.toma.pubgmc.common.items.guns.AmmoType;
import com.toma.pubgmc.common.items.guns.attachments.ItemAttachment;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.config.common.CFGWeapon;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.server.PacketFiremode;
import com.toma.pubgmc.network.sp.PacketCreateNBT;
import com.toma.pubgmc.network.sp.PacketDelayedSound;
import com.toma.pubgmc.network.sp.PacketReloadingSP;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunBase
extends PMCItem {
    public static final List<GunBase> GUNS = new ArrayList<GunBase>();
    private CFGWeapon wepStats;
    private float horizontal_recoil = 0.0f;
    private float vertical_recoil = 0.0f;
    private double reloadTime = 100.0;
    private int rate = 10;
    private int maxAmmo;
    private int exMaxAmmo;
    private AmmoType ammotype;
    private Firemode firemode;
    private Firemode[] validFiremodes = new Firemode[]{Firemode.SINGLE};
    private ReloadType reloadType;
    private GunType gunType;
    private boolean hasTwoRoundBurst = false;
    protected Supplier<SoundEvent> action = null;
    public boolean airdropWeapon = false;
    @SideOnly(value=Side.CLIENT)
    private ModelGun gunModel;
    private ItemAttachment[] barrel = new ItemAttachment[0];
    private ItemAttachment[] grip = new ItemAttachment[0];
    private ItemAttachment[] magazine = new ItemAttachment[0];
    private ItemAttachment[] stock = new ItemAttachment[0];
    private ItemAttachment[] scope = new ItemAttachment[0];
    private SoundEvent gun_shoot;
    private SoundEvent gun_silenced;
    private SoundEvent gun_reload;
    private float gun_volume;
    private float gun_volume_s;
    private ItemAmmo ammoItem;
    private int ammoCount = 0;

    protected GunBase(String name) {
        super(name);
        this.func_77637_a(PMCTabs.TAB_GUNS);
        this.func_77625_d(1);
        GUNS.add(this);
    }

    public static boolean canAttachAttachment(GunBase gun, ItemAttachment attachment) {
        switch (attachment.getType()) {
            case BARREL: {
                return DevUtil.containsD(gun.getBarrelAttachments(), attachment);
            }
            case GRIP: {
                return DevUtil.containsD(gun.getGripAttachments(), attachment);
            }
            case MAGAZINE: {
                return DevUtil.containsD(gun.getMagazineAttachments(), attachment);
            }
            case SCOPE: {
                return DevUtil.containsD(gun.getScopeAttachments(), attachment);
            }
            case STOCK: {
                return DevUtil.containsD(gun.getStockAttachments(), attachment);
            }
        }
        return false;
    }

    public SoundEvent getWeaponReloadSound() {
        return this.gun_reload;
    }

    public int getWeaponAmmoLimit(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("magazine") > 1 ? this.exMaxAmmo : this.maxAmmo;
    }

    public void shoot(World world, EntityPlayer player, ItemStack stack) {
        CooldownTracker tracker;
        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        if ((this.hasAmmo(stack) || player.field_71075_bZ.field_75098_d && !data.isReloading()) && !(tracker = player.func_184811_cZ()).func_185141_a(stack.func_77973_b())) {
            if (!world.field_72995_K) {
                if (!this.gunType.equals((Object)GunType.SHOTGUN)) {
                    EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, this);
                    world.func_72838_d((Entity)bullet);
                } else {
                    for (int i = 0; i < 8; ++i) {
                        EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, this);
                        world.func_72838_d((Entity)bullet);
                    }
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77978_p().func_74768_a("ammo", stack.func_77978_p().func_74762_e("ammo") - 1);
                }
                PacketHandler.sendToClientsAround(new PacketDelayedSound(this.playWeaponSound(stack), this.playWeaponSoundVolume(stack), player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 150.0));
            }
            tracker.func_185145_a(stack.func_77973_b(), this.getFireRate());
        }
    }

    public float playWeaponSoundVolume(ItemStack stack) {
        float volume = 1.0f;
        if (stack.func_77942_o()) {
            volume = stack.func_77978_p().func_74762_e("barrel") == 1 ? this.getGunSilencedVolume() : this.getGunVolume();
        } else {
            PUBGMCUtil.createNBT(stack);
        }
        return volume;
    }

    public SoundEvent playWeaponSound(ItemStack stack) {
        SoundEvent event = SoundEvents.field_187750_dc;
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("barrel") == 1) {
                if (this.getGunSilencedSound() != null) {
                    event = this.getGunSilencedSound();
                }
            } else {
                event = this.getGunSound();
            }
        } else {
            PUBGMCUtil.createNBT(stack);
            event = this.getGunSound();
        }
        return event;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Firemode getNextFiremode(EntityPlayer player) {
        switch (this.getFiremode()) {
            case SINGLE: {
                if (this.canGunBurstFire()) {
                    this.setFiremode(Firemode.BURST);
                    break;
                }
                this.setFiremode(Firemode.AUTO);
                break;
            }
            case BURST: {
                if (this.canGunAutofire()) {
                    this.setFiremode(Firemode.AUTO);
                    break;
                }
                this.setFiremode(Firemode.SINGLE);
                break;
            }
            case AUTO: {
                this.setFiremode(Firemode.SINGLE);
            }
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFiremode(this.firemode));
        return this.firemode;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && !worldIn.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (!player.field_71075_bZ.field_75098_d) {
                if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("isValidWeapon")) {
                    PUBGMCUtil.createWeaponNBT(stack, 0);
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketCreateNBT(0), (EntityPlayerMP)player);
                }
            } else if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("isValidWeapon")) {
                PUBGMCUtil.createWeaponNBT(stack, this.getWeaponAmmoLimit(stack));
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketCreateNBT(this.getWeaponAmmoLimit(stack)), (EntityPlayerMP)player);
            }
        }
    }

    public boolean hasAmmo(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("ammo") > 0;
    }

    public boolean hasPlayerAmmoForGun(EntityPlayer player, GunBase gun) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemAmmo) || ((ItemAmmo)stack.func_77973_b()).type != gun.getAmmoType()) continue;
            this.ammoCount = stack.func_190916_E();
            this.ammoItem = (ItemAmmo)stack.func_77973_b();
            return true;
        }
        return player.field_71075_bZ.field_75098_d;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String barrel = "default";
        String grip = "none";
        String magazine = "default";
        String stock = "default";
        String scope = "ironsight";
        if (stack.func_77942_o()) {
            NBTTagCompound c = stack.func_77978_p();
            if (c.func_74762_e("barrel") == 1) {
                barrel = "suppressor";
            }
            if (c.func_74762_e("barrel") == 2) {
                barrel = "compensator";
            }
            if (c.func_74762_e("scope") == 1) {
                scope = "red dot sight";
            }
            if (c.func_74762_e("scope") == 2) {
                scope = "holographic";
            }
            if (c.func_74762_e("scope") == 3) {
                scope = "2X";
            }
            if (c.func_74762_e("scope") == 4) {
                scope = "4X";
            }
            if (c.func_74762_e("scope") == 5) {
                scope = "8X";
            }
            if (c.func_74762_e("scope") == 6) {
                scope = "15X";
            }
            if (c.func_74762_e("grip") == 1) {
                grip = "vertical grip";
            }
            if (c.func_74762_e("grip") == 2) {
                grip = "angled grip";
            }
            if (c.func_74762_e("magazine") == 1) {
                magazine = "quickdraw";
            }
            if (c.func_74762_e("magazine") == 2) {
                magazine = "extended";
            }
            if (c.func_74762_e("magazine") == 3) {
                magazine = "extended quickdraw";
            }
            if (c.func_74762_e("stock") == 2) {
                stock = "cheekpad";
            }
            if (c.func_74762_e("stock") == 1) {
                stock = "bullet loops";
            }
        }
        tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.ammo", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.RED + this.getAmmo(stack));
        tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.firemode", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.GRAY + this.getFiremode().translatedName());
        if (GuiScreen.func_146272_n() && stack.func_77942_o()) {
            DecimalFormat f = new DecimalFormat("###.##");
            DecimalFormat g = new DecimalFormat("###.###");
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.damage", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.DARK_RED + this.wepStats.damage);
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.reloadtime", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.GREEN + g.format(this.getReloadTime(stack) / 20.0) + " " + I18n.func_135052_a((String)"gun.reloadtime.info", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.velocity", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.BLUE + f.format((double)this.wepStats.velocity * 5.5) + " " + I18n.func_135052_a((String)"gun.velocity.info", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.gravity", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.BLUE + f.format(this.wepStats.gravityModifier * 20.0f) + " " + I18n.func_135052_a((String)"gun.gravity.info", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.firerate", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.AQUA + g.format(20.0 / (double)this.getFireRate()) + " " + I18n.func_135052_a((String)"gun.firerate.info", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.ammotype", (Object[])new Object[0]) + ": " + TextFormatting.BLUE + this.ammotype.translatedName());
            tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"gun.desc.maxammo", (Object[])new Object[0]) + ": " + TextFormatting.RESET + "" + TextFormatting.RED + this.getWeaponAmmoLimit(stack));
        } else if (GuiScreen.func_146271_m()) {
            if (stack.func_77942_o()) {
                tooltip.add(TextFormatting.BOLD + "Attachments:");
                tooltip.add(TextFormatting.BOLD + "Scope:" + TextFormatting.RESET + " " + TextFormatting.GREEN + scope);
                tooltip.add(TextFormatting.BOLD + "Barrel:" + TextFormatting.RESET + "" + TextFormatting.GREEN + " " + barrel);
                tooltip.add(TextFormatting.BOLD + "Grip:" + TextFormatting.RESET + " " + TextFormatting.GREEN + grip);
                tooltip.add(TextFormatting.BOLD + "Magazine:" + TextFormatting.RESET + " " + TextFormatting.GREEN + magazine);
                tooltip.add(TextFormatting.BOLD + "Stock:" + TextFormatting.RESET + " " + TextFormatting.GREEN + stock);
            }
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gun.desc.moreinfo", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gun.desc.moreinfo2", (Object[])new Object[0]));
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public Supplier<SoundEvent> getAction() {
        return this.action;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGunModel(ModelGun model) {
        this.gunModel = model;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelGun getWeaponModel() {
        return this.gunModel;
    }

    public void setMaxAmmo(int maxAmmo, int exMaxAmmo) {
        this.maxAmmo = maxAmmo;
        this.exMaxAmmo = exMaxAmmo;
    }

    public void setReloadSound(SoundEvent reload) {
        this.gun_reload = reload;
    }

    public ItemAttachment[] getBarrelAttachments() {
        return this.barrel;
    }

    public void setBarrelAttachments(ItemAttachment ... attachments) {
        this.barrel = attachments;
    }

    public ItemAttachment[] getGripAttachments() {
        return this.grip;
    }

    public void setGripAttachments(ItemAttachment ... attachments) {
        this.grip = attachments;
    }

    public ItemAttachment[] getMagazineAttachments() {
        return this.magazine;
    }

    public void setMagazineAttachments(ItemAttachment ... attachments) {
        this.magazine = attachments;
    }

    public ItemAttachment[] getStockAttachments() {
        return this.stock;
    }

    public void setStockAttachments(ItemAttachment ... attachments) {
        this.stock = attachments;
    }

    public ItemAttachment[] getScopeAttachments() {
        return this.scope;
    }

    public void setScopeAttachments(ItemAttachment ... attachments) {
        this.scope = attachments;
    }

    public Firemode[] getValidFiremodes() {
        return this.validFiremodes;
    }

    public void setValidFiremodes(Firemode ... firemodes) {
        this.validFiremodes = firemodes;
    }

    public boolean canGunBurstFire() {
        for (Firemode f : this.validFiremodes) {
            if (!f.equals((Object)Firemode.BURST)) continue;
            return true;
        }
        return false;
    }

    public boolean canGunAutofire() {
        for (Firemode f : this.validFiremodes) {
            if (!f.equals((Object)Firemode.AUTO)) continue;
            return true;
        }
        return false;
    }

    public void setStats(CFGWeapon cfgStats) {
        this.wepStats = cfgStats;
    }

    public void setReloadTime(double time) {
        this.reloadTime = time;
    }

    public void setHorizontalRecoil(float recoil) {
        this.horizontal_recoil = recoil;
    }

    public void setVerticalRecoil(float recoil) {
        this.vertical_recoil = recoil;
    }

    public void setGunSoundVolume(float volume) {
        this.gun_volume = volume;
    }

    public void setGunSilencedSoundVolume(float volume) {
        this.gun_volume_s = volume;
    }

    public GunBase getGun() {
        return this;
    }

    public CFGWeapon getConfigurableStats() {
        return this.wepStats;
    }

    public double getReloadTime(ItemStack stack) {
        if (stack.func_77942_o() && (stack.func_77978_p().func_74762_e("magazine") == 1 || stack.func_77978_p().func_74762_e("magazine") == 3) || stack.func_77978_p().func_74762_e("stock") == 1) {
            return this.reloadTime * 0.7;
        }
        return this.reloadTime;
    }

    public AmmoType getAmmoType() {
        return this.ammotype;
    }

    public void setAmmoType(AmmoType type) {
        this.ammotype = type;
    }

    public SoundEvent getGunSound() {
        return this.gun_shoot;
    }

    public void setGunSound(SoundEvent shootSound) {
        this.gun_shoot = shootSound;
    }

    public SoundEvent getGunSilencedSound() {
        return this.gun_silenced;
    }

    public void setGunSilencedSound(SoundEvent silenced) {
        this.gun_silenced = silenced;
    }

    public float getGunVolume() {
        return this.gun_volume;
    }

    public float getGunSilencedVolume() {
        return this.gun_volume_s;
    }

    public Firemode getFiremode() {
        return this.firemode;
    }

    public void setFiremode(Firemode type) {
        this.firemode = type;
    }

    public boolean getCanSwitchFiremode() {
        return this.validFiremodes.length > 1;
    }

    public ReloadType getReloadType() {
        return this.reloadType;
    }

    public void setReloadType(ReloadType type) {
        this.reloadType = type;
    }

    public int getFireRate() {
        return this.rate;
    }

    public void setFireRate(int firerate) {
        this.rate = firerate;
    }

    public GunType getGunType() {
        return this.gunType;
    }

    public void setGunType(GunType type) {
        this.gunType = type;
    }

    public float getHorizontalRecoil(ItemStack stack) {
        return this.horizontal_recoil;
    }

    public float getVerticalRecoil(ItemStack stack) {
        return this.vertical_recoil;
    }

    public int getAmmo(ItemStack stack) {
        int a = 0;
        if (stack.func_77942_o()) {
            a = stack.func_77978_p().func_74762_e("ammo");
        }
        return a;
    }

    public boolean containsAttachment(ItemAttachment[] group, ItemAttachment toCheck) {
        for (ItemAttachment a : group) {
            if (a != toCheck) continue;
            return true;
        }
        return false;
    }

    public boolean isHasTwoRoundBurst() {
        return this.hasTwoRoundBurst;
    }

    public void setHasTwoRoundBurst(boolean hasTwoRoundBurst) {
        this.hasTwoRoundBurst = hasTwoRoundBurst;
    }

    public static enum GunType {
        LMG(40),
        PISTOL(100),
        SHOTGUN(80),
        SMG(70),
        AR(50),
        DMR(30),
        SR(10);

        private int weight;

        private GunType(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        public static GunType getTypeFromName(String name) {
            for (GunType type : GunType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        public static List<GunType> toCollection() {
            ArrayList<GunType> list = new ArrayList<GunType>(GunType.values().length);
            for (int i = 0; i < GunType.values().length; ++i) {
                list.add(GunType.values()[i]);
            }
            list = list.stream().filter(type -> type != LMG).collect(Collectors.toList());
            return list;
        }
    }

    public static enum ReloadType {
        MAGAZINE,
        SINGLE,
        KAR98K;


        public void handleReload(EntityPlayer player) {
            ItemStack heldItem;
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (ConfigPMC.common.world.gunsEnabled && (heldItem = player.func_184614_ca()).func_77973_b() instanceof GunBase) {
                data.setAiming(false);
                GunBase gun = (GunBase)heldItem.func_77973_b();
                if ((heldItem.func_77978_p().func_74762_e("ammo") == gun.getWeaponAmmoLimit(heldItem) || !gun.hasPlayerAmmoForGun(player, gun)) && data.isReloading()) {
                    data.setReloading(false);
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketReloadingSP(false), (EntityPlayerMP)player);
                }
                if (heldItem.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(heldItem)) {
                    if (gun.getReloadType() == MAGAZINE) {
                        while ((gun.hasPlayerAmmoForGun(player, gun) || player.field_71075_bZ.field_75098_d) && heldItem.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(heldItem)) {
                            int ammoInInventory;
                            int ammoInGun = heldItem.func_77978_p().func_74762_e("ammo");
                            int ammoToFill = gun.getWeaponAmmoLimit(heldItem) - ammoInGun;
                            if (ammoToFill > (ammoInInventory = gun.ammoCount)) {
                                ammoToFill = ammoInInventory;
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                ItemAmmo ammo = (ItemAmmo)gun.ammoItem.getAmmoItem();
                                player.field_71071_by.func_174925_a(ammo.getAmmoItem(), 0, ammoToFill, null);
                            }
                            heldItem.func_77978_p().func_74768_a("ammo", ammoInGun + ammoToFill);
                        }
                        data.setReloading(false);
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketReloadingSP(false), (EntityPlayerMP)player);
                    } else if (gun.getReloadType() == SINGLE) {
                        if (gun.hasPlayerAmmoForGun(player, gun) || player.field_71075_bZ.field_75098_d) {
                            if (heldItem.func_77978_p().func_74762_e("ammo") == gun.getWeaponAmmoLimit(heldItem)) {
                                data.setReloading(false);
                                PacketHandler.INSTANCE.sendTo((IMessage)new PacketReloadingSP(false), (EntityPlayerMP)player);
                            }
                            if (heldItem.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(heldItem)) {
                                ItemAmmo ammo = (ItemAmmo)gun.ammoItem.getAmmoItem();
                                if (!player.field_71075_bZ.field_75098_d) {
                                    player.field_71071_by.func_174925_a(ammo.getAmmoItem(), 0, 1, null);
                                }
                                heldItem.func_77978_p().func_74768_a("ammo", heldItem.func_77978_p().func_74762_e("ammo") + 1);
                            }
                        }
                    } else if (gun.getReloadType() == KAR98K) {
                        if (!gun.hasAmmo(heldItem)) {
                            while ((gun.hasPlayerAmmoForGun(player, gun) || player.field_71075_bZ.field_75098_d) && heldItem.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(heldItem)) {
                                ItemAmmo ammo = (ItemAmmo)gun.ammoItem.getAmmoItem();
                                if (!player.field_71075_bZ.field_75098_d) {
                                    player.field_71071_by.func_174925_a(ammo.getAmmoItem(), 0, 1, null);
                                }
                                heldItem.func_77978_p().func_74768_a("ammo", heldItem.func_77978_p().func_74762_e("ammo") + 1);
                            }
                            data.setReloading(false);
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketReloadingSP(false), (EntityPlayerMP)player);
                        } else if (heldItem.func_77978_p().func_74762_e("ammo") > 0 && heldItem.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(heldItem)) {
                            ItemAmmo ammo = (ItemAmmo)gun.ammoItem.getAmmoItem();
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.field_71071_by.func_174925_a(ammo.getAmmoItem(), 0, 1, null);
                            }
                            heldItem.func_77978_p().func_74768_a("ammo", heldItem.func_77978_p().func_74762_e("ammo") + 1);
                        }
                    } else {
                        throw new IllegalArgumentException("Unknown reload type. Report this to mod author!");
                    }
                }
            }
        }
    }

    public static enum Firemode {
        SINGLE("gun.firemode.single"),
        BURST("gun.firemode.burst"),
        AUTO("gun.firemode.auto");

        private String name;

        private Firemode(String name) {
            this.name = name;
        }

        public static Firemode[] all() {
            return new Firemode[]{SINGLE, BURST, AUTO};
        }

        public static Firemode[] noBurst() {
            return new Firemode[]{SINGLE, AUTO};
        }

        public static Firemode[] noAuto() {
            return new Firemode[]{SINGLE, BURST};
        }

        @SideOnly(value=Side.CLIENT)
        public String translatedName() {
            return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
        }
    }
}

