/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.items.guns;

import com.google.common.base.Preconditions;
import com.toma.pubgmc.common.items.guns.AmmoType;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.config.common.CFGWeapon;
import com.toma.pubgmc.util.game.loot.LootManager;
import com.toma.pubgmc.util.game.loot.LootType;
import java.util.function.Supplier;
import net.minecraft.util.SoundEvent;

public class GunBuilder {
    String name;
    int reloadTime;
    int firerate;
    int maxAmmo;
    int exMaxAmmo;
    float vertical;
    float horizontal;
    float volumeNormal;
    float volumeSilenced;
    boolean twoRoundBurst;
    boolean airdrop;
    GunBase.GunType weaponType;
    GunBase.ReloadType reloadType;
    AmmoType ammoType;
    GunBase.Firemode defFiremode;
    GunBase.Firemode[] validFiremodes;
    SoundEvent reloadSound;
    SoundEvent shootNormal;
    SoundEvent shootSilenced;
    CFGWeapon cfgStats;
    Supplier<SoundEvent> action;

    private GunBuilder() {
    }

    public static GunBuilder create(String regName) {
        GunBuilder builder = new GunBuilder();
        builder.name = regName;
        builder.twoRoundBurst = false;
        return builder;
    }

    private static <T> boolean isObjectInsideGroup(T obj, T[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            T o = arr[i];
            if (!obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    private static <T> T checkNotNull(T obj) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(obj + " cannot be null!");
        }
        return obj;
    }

    private static float validateFloat(float floatToValidate, float min, float max) throws IllegalArgumentException {
        if (floatToValidate < min || floatToValidate > max) {
            throw new IllegalArgumentException("Float value must be in <" + min + ";" + max + "> range! Got: " + floatToValidate);
        }
        return floatToValidate;
    }

    private static double validateDouble(double doubleToValidate, double min, double max) throws IllegalArgumentException {
        if (doubleToValidate < min || doubleToValidate > max) {
            throw new IllegalArgumentException("Double value must be in <" + min + ";" + max + "> range! Got: " + doubleToValidate);
        }
        return doubleToValidate;
    }

    private static int validateInt(int intToValidate, int min, int max) throws IllegalArgumentException {
        if (intToValidate < min || intToValidate > max) {
            throw new IllegalArgumentException("Int value must be in <" + min + ";" + max + "> range! Got: " + intToValidate);
        }
        return intToValidate;
    }

    public GunBuilder stats(CFGWeapon cfg) {
        this.cfgStats = cfg;
        return this;
    }

    public GunBuilder recoil(float vertical, float horizontal) {
        this.vertical = vertical;
        this.horizontal = horizontal;
        return this;
    }

    public GunBuilder reload(GunBase.ReloadType typeOfReload, int reloadTime, SoundEvent reloadSound) {
        this.reloadType = typeOfReload;
        this.reloadTime = reloadTime;
        this.reloadSound = reloadSound;
        return this;
    }

    public GunBuilder firerate(int firerate) {
        this.firerate = firerate;
        return this;
    }

    public GunBuilder ammo(AmmoType ammoType, int maxAmmo, int exMaxAmmo) {
        this.ammoType = ammoType;
        this.maxAmmo = maxAmmo;
        this.exMaxAmmo = exMaxAmmo;
        return this;
    }

    public GunBuilder ammo(AmmoType ammoType, int maxAmmo) {
        this.ammoType = ammoType;
        this.maxAmmo = maxAmmo;
        this.exMaxAmmo = maxAmmo;
        return this;
    }

    public GunBuilder firemode(GunBase.Firemode defaultFiremode, GunBase.Firemode ... validFiremodes) {
        this.defFiremode = defaultFiremode;
        this.validFiremodes = validFiremodes;
        return this;
    }

    public GunBuilder setTwoRoundBurst() {
        this.twoRoundBurst = true;
        return this;
    }

    public GunBuilder weaponType(GunBase.GunType type) {
        this.weaponType = type;
        return this;
    }

    public GunBuilder sound(SoundEvent shootNormal, float volume, SoundEvent shootSilenced, float silencedVolume) {
        this.shootNormal = shootNormal;
        this.volumeNormal = volume;
        this.shootSilenced = shootSilenced;
        this.volumeSilenced = silencedVolume;
        return this;
    }

    public GunBuilder sound(SoundEvent normal, float volume) {
        this.shootNormal = normal;
        this.volumeNormal = volume;
        this.shootSilenced = normal;
        this.volumeSilenced = volume;
        return this;
    }

    public GunBuilder addBoltAction(Supplier<SoundEvent> action) {
        this.action = action;
        return this;
    }

    public GunBuilder airdropOnly() {
        this.airdrop = true;
        return this;
    }

    public GunBase build() {
        this.cfgStats = GunBuilder.checkNotNull(this.cfgStats);
        this.vertical = GunBuilder.validateFloat(this.vertical, 0.1f, 10.0f);
        this.horizontal = GunBuilder.validateFloat(this.horizontal, 0.1f, 10.0f);
        this.reloadType = GunBuilder.checkNotNull(this.reloadType);
        this.reloadTime = GunBuilder.validateInt(this.reloadTime, 1, 150);
        this.firerate = GunBuilder.validateInt(this.firerate, 1, 150);
        this.ammoType = GunBuilder.checkNotNull(this.ammoType);
        this.maxAmmo = GunBuilder.validateInt(this.maxAmmo, 1, 100);
        this.exMaxAmmo = GunBuilder.validateInt(this.exMaxAmmo, 1, 100);
        this.defFiremode = GunBuilder.checkNotNull(this.defFiremode);
        this.validFiremodes = GunBuilder.checkNotNull(this.validFiremodes);
        this.weaponType = GunBuilder.checkNotNull(this.weaponType);
        this.shootNormal = GunBuilder.checkNotNull(this.shootNormal);
        this.shootSilenced = GunBuilder.checkNotNull(this.shootSilenced);
        this.volumeNormal = GunBuilder.validateFloat(this.volumeNormal, 1.0f, 40.0f);
        this.volumeSilenced = GunBuilder.validateFloat(this.volumeSilenced, 1.0f, 30.0f);
        this.reloadSound = GunBuilder.checkNotNull(this.reloadSound);
        if (this.action != null) {
            Preconditions.checkNotNull((Object)this.action.get(), (Object)"Cannot add IBoltAction with null soundevent");
        }
        if (this.twoRoundBurst && !GunBuilder.isObjectInsideGroup(GunBase.Firemode.BURST, this.validFiremodes)) {
            throw new NullPointerException("Two round is registered, but BURST firemode isn't valid for the weapon " + this.name);
        }
        GunBase gun = new GunBase(this.name);
        LootManager.register(LootType.GUN, new LootManager.LootEntry(gun, this.weaponType.getWeight(), this.airdrop));
        gun.setStats(this.cfgStats);
        gun.setVerticalRecoil(this.vertical);
        gun.setHorizontalRecoil(this.horizontal);
        gun.setReloadType(this.reloadType);
        gun.setReloadTime(this.reloadTime);
        gun.setFireRate(this.firerate);
        gun.setAmmoType(this.ammoType);
        gun.setMaxAmmo(this.maxAmmo, this.exMaxAmmo);
        gun.setFiremode(this.defFiremode);
        gun.setValidFiremodes(this.validFiremodes);
        gun.setHasTwoRoundBurst(this.twoRoundBurst);
        gun.setGunType(this.weaponType);
        gun.setGunSound(this.shootNormal);
        gun.setGunSoundVolume(this.volumeNormal);
        gun.setGunSilencedSound(this.shootSilenced);
        gun.setGunSilencedSoundVolume(this.volumeSilenced);
        gun.setReloadSound(this.reloadSound);
        gun.action = this.action;
        return gun;
    }
}

