/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.items.guns.attachments;

import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.common.items.guns.attachments.IAttachment;
import com.toma.pubgmc.common.items.guns.attachments.ItemAttachment;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.util.PUBGMCUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryAttachments
extends InventoryBasic {
    private boolean using = false;
    private ItemStack gun;

    public InventoryAttachments(int slots, ItemStack gun) {
        super("Weapon Attachments", true, slots);
        this.gun = gun;
    }

    public void func_174889_b(EntityPlayer player) {
        this.func_70299_a(0, this.getBarrelAttachment(this.gun));
        this.func_70299_a(1, this.getGripAttachment(this.gun));
        this.func_70299_a(2, this.getMagazineAttachment(this.gun));
        this.func_70299_a(3, this.getStockAttachment(this.gun));
        this.func_70299_a(4, this.getScopeAttachment(this.gun));
    }

    public void func_174886_c(EntityPlayer player) {
        this.resetNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAttachment)) continue;
            if (GunBase.canAttachAttachment((GunBase)this.gun.func_77973_b(), (ItemAttachment)stack.func_77973_b())) {
                this.gun.func_77978_p().func_74768_a(IAttachment.Type.values()[i].getName(), ((ItemAttachment)stack.func_77973_b()).getID(stack.func_77973_b()));
                continue;
            }
            if (player.field_70170_p.field_72995_K) continue;
            EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, stack.func_77946_l());
            item.func_174867_a(30);
            player.field_70170_p.func_72838_d((Entity)item);
        }
    }

    private void resetNBT() {
        NBTTagCompound nbt = this.gun.func_77978_p();
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            nbt.func_74768_a(IAttachment.Type.values()[i].getName(), 0);
        }
        this.gun.func_77982_d(nbt);
    }

    public int func_70302_i_() {
        return 7;
    }

    private ItemStack getBarrelAttachment(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            int attachment = stack.func_77978_p().func_74762_e("barrel") - 1;
            if (attachment < 0) {
                return ItemStack.field_190927_a;
            }
            int weaponType = 0;
            if (gun.getGunType() == GunBase.GunType.SMG) {
                weaponType = 1;
            } else if (gun.getGunType() == GunBase.GunType.AR) {
                weaponType = 2;
            } else if (gun.getGunType() == GunBase.GunType.DMR || gun.getGunType() == GunBase.GunType.SR) {
                weaponType = 3;
            }
            Item[][] attachments = new Item[][]{{PMCRegistry.PMCItems.SILENCER_PISTOL}, {PMCRegistry.PMCItems.SILENCER_SMG, PMCRegistry.PMCItems.COMPENSATOR_SMG}, {PMCRegistry.PMCItems.SILENCER_AR, PMCRegistry.PMCItems.COMPENSATOR_AR}, {PMCRegistry.PMCItems.SILENCER_SNIPER, PMCRegistry.PMCItems.COMPENSATOR_SNIPER}};
            return new ItemStack(attachments[weaponType][attachment]);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getMagazineAttachment(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            int magazine = stack.func_77978_p().func_74762_e("magazine") - 1;
            if (magazine < 0) {
                return ItemStack.field_190927_a;
            }
            Item[][] mags = new Item[][]{{PMCRegistry.PMCItems.QUICKDRAW_MAG_PISTOL, PMCRegistry.PMCItems.EXTENDED_MAG_PISTOL, PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_PISTOL}, {PMCRegistry.PMCItems.QUICKDRAW_MAG_SMG, PMCRegistry.PMCItems.EXTENDED_MAG_SMG, PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_SMG}, {PMCRegistry.PMCItems.QUICKDRAW_MAG_AR, PMCRegistry.PMCItems.EXTENDED_MAG_AR, PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_AR}, {PMCRegistry.PMCItems.QUICKDRAW_MAG_SNIPER, PMCRegistry.PMCItems.EXTENDED_MAG_SNIPER, PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_SNIPER}};
            int weaponType = 0;
            if (gun.getGunType() == GunBase.GunType.SMG) {
                weaponType = 1;
            } else if (gun.getGunType() == GunBase.GunType.AR) {
                weaponType = 2;
            } else if (gun.getGunType() == GunBase.GunType.DMR || gun.getGunType() == GunBase.GunType.SR) {
                weaponType = 3;
            }
            return new ItemStack(mags[weaponType][magazine]);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getGripAttachment(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            int grip = stack.func_77978_p().func_74762_e("grip");
            return grip < 1 ? ItemStack.field_190927_a : (grip == 1 ? new ItemStack((Item)PMCRegistry.PMCItems.GRIP_VERTICAL) : new ItemStack((Item)PMCRegistry.PMCItems.GRIP_ANGLED));
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getScopeAttachment(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            int scope = stack.func_77978_p().func_74762_e("scope");
            switch (scope) {
                case 1: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.RED_DOT);
                }
                case 2: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.HOLOGRAPHIC);
                }
                case 3: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.SCOPE2X);
                }
                case 4: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.SCOPE4X);
                }
                case 5: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.SCOPE8X);
                }
                case 6: {
                    return new ItemStack((Item)PMCRegistry.PMCItems.SCOPE15X);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getStockAttachment(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            int id = stack.func_77978_p().func_74762_e("stock");
            if (id == 1 && (gun.getGunType() == GunBase.GunType.PISTOL || gun.getGunType() == GunBase.GunType.SR)) {
                return new ItemStack((Item)PMCRegistry.PMCItems.BULLET_LOOPS_SNIPER);
            }
            if (id == 1 && gun.getGunType() == GunBase.GunType.SHOTGUN) {
                return new ItemStack((Item)PMCRegistry.PMCItems.BULLET_LOOPS_SHOTGUN);
            }
            if (id == 2) {
                return new ItemStack((Item)PMCRegistry.PMCItems.CHEEKPAD);
            }
        }
        return ItemStack.field_190927_a;
    }

    private void detachAttachments(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            if (stack.func_77942_o()) {
                NBTTagCompound att = stack.func_77978_p();
                if (att.func_74762_e("barrel") > 0) {
                    if (att.func_74762_e("barrel") == 1) {
                        switch (gun.getGunType()) {
                            case PISTOL: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.SILENCER_PISTOL));
                                break;
                            }
                            case SMG: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.SILENCER_SMG));
                                break;
                            }
                            case AR: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.SILENCER_AR));
                                break;
                            }
                            case DMR: 
                            case SR: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.SILENCER_SNIPER));
                                break;
                            }
                        }
                        att.func_74768_a("barrel", 0);
                    } else if (att.func_74762_e("barrel") == 2) {
                        switch (gun.getGunType()) {
                            case SMG: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.COMPENSATOR_SMG));
                                break;
                            }
                            case AR: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.COMPENSATOR_AR));
                                break;
                            }
                            case DMR: 
                            case SR: {
                                this.func_70299_a(2, new ItemStack((Item)PMCRegistry.PMCItems.COMPENSATOR_SNIPER));
                                break;
                            }
                        }
                        att.func_74768_a("barrel", 0);
                    }
                }
                if (att.func_74762_e("scope") > 0) {
                    if (att.func_74762_e("scope") == 1) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.RED_DOT));
                    } else if (att.func_74762_e("scope") == 2) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.HOLOGRAPHIC));
                    } else if (att.func_74762_e("scope") == 3) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.SCOPE2X));
                    } else if (att.func_74762_e("scope") == 4) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.SCOPE4X));
                    } else if (att.func_74762_e("scope") == 5) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.SCOPE8X));
                    } else if (att.func_74762_e("scope") == 6) {
                        this.func_70299_a(1, new ItemStack((Item)PMCRegistry.PMCItems.SCOPE15X));
                    }
                    att.func_74768_a("scope", 0);
                }
                if (att.func_74762_e("grip") > 0) {
                    if (att.func_74762_e("grip") == 1) {
                        this.func_70299_a(3, new ItemStack((Item)PMCRegistry.PMCItems.GRIP_VERTICAL));
                    } else if (att.func_74762_e("grip") == 2) {
                        this.func_70299_a(3, new ItemStack((Item)PMCRegistry.PMCItems.GRIP_ANGLED));
                    }
                    att.func_74768_a("grip", 0);
                }
                if (att.func_74762_e("stock") > 0) {
                    if (att.func_74762_e("stock") == 1) {
                        switch (gun.getGunType()) {
                            case PISTOL: 
                            case SR: {
                                this.func_70299_a(5, new ItemStack((Item)PMCRegistry.PMCItems.BULLET_LOOPS_SNIPER));
                                break;
                            }
                            case SHOTGUN: {
                                this.func_70299_a(5, new ItemStack((Item)PMCRegistry.PMCItems.BULLET_LOOPS_SHOTGUN));
                                break;
                            }
                        }
                    } else if (att.func_74762_e("stock") == 2) {
                        this.func_70299_a(5, new ItemStack((Item)PMCRegistry.PMCItems.CHEEKPAD));
                    }
                    att.func_74768_a("stock", 0);
                }
                if (att.func_74762_e("magazine") > 0) {
                    if (att.func_74762_e("magazine") == 1) {
                        switch (gun.getGunType()) {
                            case PISTOL: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.QUICKDRAW_MAG_PISTOL));
                                break;
                            }
                            case SMG: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.QUICKDRAW_MAG_SMG));
                                break;
                            }
                            case AR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.QUICKDRAW_MAG_AR));
                                break;
                            }
                            case DMR: 
                            case SR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.QUICKDRAW_MAG_SNIPER));
                                break;
                            }
                        }
                    } else if (att.func_74762_e("magazine") == 2) {
                        switch (gun.getGunType()) {
                            case PISTOL: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_MAG_PISTOL));
                                break;
                            }
                            case SMG: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_MAG_SMG));
                                break;
                            }
                            case AR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_MAG_AR));
                                break;
                            }
                            case DMR: 
                            case SR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_MAG_SNIPER));
                                break;
                            }
                        }
                    } else if (att.func_74762_e("magazine") == 3) {
                        switch (gun.getGunType()) {
                            case PISTOL: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_PISTOL));
                                break;
                            }
                            case SMG: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_SMG));
                                break;
                            }
                            case AR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_AR));
                                break;
                            }
                            case DMR: 
                            case SR: {
                                this.func_70299_a(4, new ItemStack((Item)PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_SNIPER));
                                break;
                            }
                        }
                    }
                    att.func_74768_a("magazine", 0);
                }
            } else {
                PUBGMCUtil.createNBT(stack);
            }
        }
    }
}

