/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.items.heal;

import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.items.PMCItem;
import com.toma.pubgmc.util.game.loot.LootManager;
import com.toma.pubgmc.util.game.loot.LootType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ItemHealing
extends PMCItem {
    public float health;
    public float boost;

    public ItemHealing(String name, int weight, int amount) {
        super(name);
        this.func_77625_d(1);
        LootManager.register(LootType.HEAL, new LootManager.LootEntry(this, weight, false, amount));
    }

    public abstract Action getAction();

    public abstract int getUseTime();

    public abstract EnumAction getUseAction();

    public int func_77626_a(ItemStack stack) {
        return this.getUseTime();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getUseAction();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (this.getAction() == Action.HEAL && this.canPlayerHeal(player)) {
                float health = this.getHealAmount(player);
                health = player.func_110143_aJ() + health > 20.0f ? 20.0f - player.func_110143_aJ() : health;
                player.func_70691_i(health);
            } else if (this.getAction() == Action.BOOST) {
                data.addBoost(this.getBoostAmount());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.canPlayerHeal(playerIn)) {
            playerIn.func_184598_c(handIn);
        } else if (!worldIn.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Conditions to use stack not met!"));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public float getHealAmount(EntityPlayer player) {
        return this.health;
    }

    public float getBoostAmount() {
        return this.boost;
    }

    public boolean canPlayerHeal(EntityPlayer player) {
        return true;
    }

    public static enum Action {
        HEAL,
        BOOST;

    }
}

