/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.tileentity;

import com.toma.pubgmc.util.recipes.ICraftingInventory;
import com.toma.pubgmc.util.recipes.PMCIngredient;
import com.toma.pubgmc.util.recipes.PMCRecipe;
import com.toma.pubgmc.util.recipes.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileEntityGunWorkbench
extends TileEntity
implements ICraftingInventory {
    private static final int OUTPUT = 8;
    public static ArrayList<List<PMCRecipe>> RECIPES = new ArrayList(PMCRecipe.CraftingCategory.values().length);
    private static List<PMCRecipe> GUNS;
    private static List<PMCRecipe> AMMO;
    private static List<PMCRecipe> ATTACHMENT;
    private static List<PMCRecipe> CLOTHING;
    private static List<PMCRecipe> HEALING;
    private static List<PMCRecipe> THROWABLES;
    private static List<PMCRecipe> VEHICLES;
    public PMCRecipe.CraftingCategory selectedCat = PMCRecipe.CraftingCategory.GUNS;
    public int selectedIndex = 0;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    public static void init() {
        GUNS = RecipeRegistry.asList(PMCRecipe.CraftingCategory.GUNS);
        AMMO = RecipeRegistry.asList(PMCRecipe.CraftingCategory.AMMO);
        ATTACHMENT = RecipeRegistry.asList(PMCRecipe.CraftingCategory.ATTACHMENTS);
        CLOTHING = RecipeRegistry.asList(PMCRecipe.CraftingCategory.WEARABLES);
        HEALING = RecipeRegistry.asList(PMCRecipe.CraftingCategory.HEALS);
        THROWABLES = RecipeRegistry.asList(PMCRecipe.CraftingCategory.THROWABLES);
        VEHICLES = RecipeRegistry.asList(PMCRecipe.CraftingCategory.VEHICLES);
        RECIPES.add(GUNS);
        RECIPES.add(AMMO);
        RECIPES.add(ATTACHMENT);
        RECIPES.add(HEALING);
        RECIPES.add(THROWABLES);
        RECIPES.add(CLOTHING);
        RECIPES.add(VEHICLES);
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public String func_70005_c_() {
        return "container.gun_workbench";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size();
    }

    public void craft(PMCRecipe recipe) {
        boolean valid = true;
        for (PMCIngredient ing : recipe.ingredients) {
            int amount = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.func_70301_a(i).func_77973_b() != ing.getIngredient().func_77973_b()) continue;
                amount += this.func_70301_a(i).func_190916_E();
            }
            if (amount >= ing.getIngredient().func_190916_E()) continue;
            valid = false;
        }
        if (valid) {
            for (PMCIngredient ing : recipe.ingredients) {
                this.clearItems(ing.getIngredient(), ing.getIngredient().func_190916_E());
            }
            this.func_70299_a(8, new ItemStack(recipe.result, recipe.resultCount));
            recipe.onCraft(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.selectedIndex = compound.func_74764_b("selectedIndex") ? compound.func_74762_e("selectedIndex") : 0;
        this.selectedCat = compound.func_74764_b("selectedCategory") ? PMCRecipe.CraftingCategory.values()[compound.func_74762_e("selectedCategory")] : PMCRecipe.CraftingCategory.GUNS;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74768_a("selectedIndex", this.selectedIndex);
        compound.func_74768_a("selectedCategory", this.selectedCat.ordinal());
        return compound;
    }

    private void clearItems(ItemStack itemStack, int amount) {
        int remaining = amount;
        for (ItemStack stack : this.inventory) {
            if (stack.func_77973_b() != itemStack.func_77973_b()) continue;
            if (remaining > stack.func_190916_E()) {
                remaining -= stack.func_190916_E();
                stack.func_190918_g(stack.func_190916_E());
                continue;
            }
            stack.func_190920_e(stack.func_190916_E() - remaining);
            remaining = 0;
            break;
        }
        if (remaining > 0) {
            throw new IllegalStateException("Fatal error occured when attempted to remove right item count from inventory. Not enought items");
        }
    }
}

