/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.config.common;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.util.INBTSerializable;

public final class CFGVehicle
implements INBTSerializable<NBTTagCompound> {
    @Config.Name(value="Max Health")
    @Config.Comment(value={"Vehicle maximum health"})
    @Config.RangeDouble(min=1.0, max=1500.0)
    public float maxHealth;
    @Config.Name(value="Max Speed")
    @Config.Comment(value={"Vehicle max speed"})
    @Config.RangeDouble(min=0.5, max=3.0)
    public float maxSpeed;
    @Config.Name(value="Acceleration")
    @Config.Comment(value={"Vehicle speed acceleration", "This also applies for braking, which is Acceleration*2"})
    @Config.RangeDouble(min=0.001, max=1.0)
    public float acceleration;
    @Config.Name(value="Turning Speed")
    @Config.Comment(value={"Turning angle increase per tick"})
    @Config.RangeDouble(min=0.1, max=1.0)
    public float turningSpeed;
    @Config.Name(value="Max Turning Angle")
    @Config.Comment(value={"Maximal angle at which can vehicle turn"})
    @Config.RangeDouble(min=1.0, max=10.0)
    public float maxTurningAngle;

    public CFGVehicle(float health, float speed, float angle, float acceleration, float turningAcceleration) {
        this.maxHealth = health;
        this.maxSpeed = speed;
        this.maxTurningAngle = angle;
        this.acceleration = acceleration;
        this.turningSpeed = turningAcceleration;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74776_a("health", this.maxHealth);
        c.func_74776_a("speed", this.maxSpeed);
        c.func_74776_a("acceleration", this.acceleration);
        c.func_74776_a("turningSpeed", this.turningSpeed);
        c.func_74776_a("maxAngle", this.maxTurningAngle);
        return c;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.maxHealth = nbt.func_74760_g("health");
        this.maxSpeed = nbt.func_74760_g("speed");
        this.acceleration = nbt.func_74760_g("acceleration");
        this.turningSpeed = nbt.func_74760_g("turningSpeed");
        this.maxTurningAngle = nbt.func_74760_g("maxAngle");
    }
}

