/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.config.common;

import com.toma.pubgmc.config.common.CFGEnumAirdropLoot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.util.INBTSerializable;

public final class CFGWorld
implements INBTSerializable<NBTTagCompound> {
    @Config.Name(value="Allow vehicles")
    public boolean vehicleSpawning = true;
    @Config.Name(value="Allow gun loot")
    public boolean enableGunLoot = true;
    @Config.Name(value="Airdrop loot")
    public CFGEnumAirdropLoot airdropLoot = CFGEnumAirdropLoot.ALL;
    @Config.Name(value="Allow guns")
    @Config.Comment(value={"You can use this to disable all guns, it will no longer shoot"})
    public boolean gunsEnabled = true;
    @Config.Name(value="Plane path height")
    @Config.RangeInt(min=10, max=255)
    public int planeHeight = 150;
    @Config.Name(value="Plane start delay")
    @Config.Comment(value={"How many seconds plane will wait in starting position when game starts"})
    public int planeDelay = 5;
    @Config.Name(value="Title zone notification")
    @Config.Comment(value={"If true you will receive zone shrink notification through title instead of chat"})
    public boolean titleZoneNotifications = true;
    @Config.Name(value="Default ghillie colors")
    public int[] defaultGhillieColors = new int[]{5429504, 14192640, 0xDBDBDB};

    public NBTTagCompound serializeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        NBTTagList colors = new NBTTagList();
        c.func_74757_a("vehicles", this.vehicleSpawning);
        c.func_74757_a("gunLoot", this.enableGunLoot);
        c.func_74768_a("airdropLoot", this.airdropLoot.ordinal());
        c.func_74757_a("guns", this.gunsEnabled);
        c.func_74768_a("planeHeight", this.planeHeight);
        c.func_74768_a("planeDelay", this.planeDelay);
        c.func_74757_a("zoneNotif", this.titleZoneNotifications);
        for (int i = 0; i < this.defaultGhillieColors.length; ++i) {
            colors.func_74742_a((NBTBase)new NBTTagInt(this.defaultGhillieColors[i]));
        }
        c.func_74782_a("colors", (NBTBase)colors);
        return c;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.vehicleSpawning = nbt.func_74767_n("vehicles");
        this.enableGunLoot = nbt.func_74767_n("gunLoot");
        this.airdropLoot = CFGEnumAirdropLoot.values()[nbt.func_74762_e("airdropLoot")];
        this.gunsEnabled = nbt.func_74767_n("guns");
        this.planeHeight = nbt.func_74762_e("planeHeight");
        this.planeDelay = nbt.func_74762_e("planeDelay");
        this.titleZoneNotifications = nbt.func_74767_n("zoneNotif");
        NBTTagList colors = nbt.func_150295_c("colors", 3);
        this.defaultGhillieColors = new int[colors.func_74745_c()];
        for (int i = 0; i < colors.func_74745_c(); ++i) {
            this.defaultGhillieColors[i] = colors.func_186858_c(i);
        }
    }
}

