/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.core;

import com.toma.pubgmc.Pubgmc;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PMCClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfEnv = !name.equals(transformedName);
        switch (transformedName) {
            case "net.minecraft.client.model.ModelBiped": {
                return this.patchModelBiped(basicClass, isObfEnv);
            }
            case "net.minecraft.client.renderer.entity.layers.LayerHeldItem": {
                return this.patchLayerHeldItem(basicClass, isObfEnv);
            }
        }
        return basicClass;
    }

    public byte[] patchModelBiped(byte[] bytes, boolean isObf) {
        long l = System.currentTimeMillis();
        Pubgmc.logger.info("Patching net.minecraft.client.model.ModelBiped");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Name methodName = new Name("setRotationAngles", "func_78087_a");
        String methodParams = "(FFFFFFLnet/minecraft/entity/Entity;)V";
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(methodName.getName(isObf)) || !methodNode.desc.equals(methodParams)) continue;
            AbstractInsnNode target = null;
            for (AbstractInsnNode abstractInsnNode : methodNode.instructions.toArray()) {
                if (abstractInsnNode.getOpcode() != 184 || !(abstractInsnNode.getNext() instanceof LabelNode)) continue;
                target = abstractInsnNode;
                break;
            }
            if (target != null) {
                Pubgmc.logger.info("Found the required method");
                InsnList eventInsns = new InsnList();
                eventInsns.add((AbstractInsnNode)new LabelNode());
                eventInsns.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
                eventInsns.add((AbstractInsnNode)new TypeInsnNode(187, "com/toma/pubgmc/event/client/SetupAnglesEvent"));
                eventInsns.add((AbstractInsnNode)new InsnNode(89));
                eventInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                eventInsns.add((AbstractInsnNode)new VarInsnNode(25, 7));
                eventInsns.add((AbstractInsnNode)new MethodInsnNode(183, "com/toma/pubgmc/event/client/SetupAnglesEvent", "<init>", "(Lnet/minecraft/client/model/ModelBiped;Lnet/minecraft/entity/Entity;)V", false));
                eventInsns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
                eventInsns.add((AbstractInsnNode)new InsnNode(87));
                methodNode.instructions.insertBefore(target, eventInsns);
                Pubgmc.logger.info("Successfully patched net.minecraft.client.model.ModelBiped class. Took {} ms", (Object)(System.currentTimeMillis() - l));
                break;
            }
            Pubgmc.logger.fatal("Patching failed, things are not going to work!");
            break;
        }
        ClassWriter classWriter = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public byte[] patchLayerHeldItem(byte[] bytes, boolean isObf) {
        long l = System.currentTimeMillis();
        Pubgmc.logger.info("Patching net.minecraft.client.renderer.entity.layers.LayerHeldItem");
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        Name methodName = new Name("renderHeldItem", "func_188358_a");
        String params = "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;Lnet/minecraft/util/EnumHandSide;)V";
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(methodName.getName(isObf)) || !methodNode.desc.equals(params)) continue;
            AbstractInsnNode target = null;
            for (AbstractInsnNode abstractInsnNode : methodNode.instructions.toArray()) {
                if (abstractInsnNode.getOpcode() != 184 || !(abstractInsnNode.getNext() instanceof LabelNode) || !(abstractInsnNode.getNext().getNext() instanceof LineNumberNode) || abstractInsnNode.getNext().getNext().getNext().getOpcode() != 184) continue;
                target = abstractInsnNode;
                break;
            }
            if (target != null) {
                Pubgmc.logger.info("Found the required method");
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new LabelNode());
                list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
                list.add((AbstractInsnNode)new TypeInsnNode(187, "com/toma/pubgmc/event/client/RenderItemInHandEvent"));
                list.add((AbstractInsnNode)new InsnNode(89));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                list.add((AbstractInsnNode)new MethodInsnNode(183, "com/toma/pubgmc/event/client/RenderItemInHandEvent", "<init>", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumHandSide;)V", false));
                list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
                list.add((AbstractInsnNode)new InsnNode(87));
                methodNode.instructions.insert(target, list);
                Pubgmc.logger.info("Successfully patched net.minecraft.client.renderer.entity.layers.LayerHeldItem class. Took {} ms", (Object)(System.currentTimeMillis() - l));
                break;
            }
            Pubgmc.logger.fatal("Patching failed, things are not going to work!");
            break;
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private class Name {
        private final String obf;
        private final String deobf;

        public Name(String deobf, String obf) {
            this.obf = obf;
            this.deobf = deobf;
        }

        public String getName(boolean isObfEnv) {
            return isObfEnv ? this.obf : this.deobf;
        }
    }
}

