/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.network.server;

import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.items.guns.GunBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketServerAction
implements IMessage {
    private ServerAction action;
    private boolean data;

    public PacketServerAction() {
    }

    public PacketServerAction(boolean data, ServerAction action) {
        this.data = data;
        this.action = action;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.data);
        buf.writeInt(this.action.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.data = buf.readBoolean();
        this.action = ServerAction.values()[buf.readInt()];
    }

    public static enum ServerAction {
        AIM,
        RELOAD,
        NIGHT_VISION;

    }

    public static class Handler
    implements IMessageHandler<PacketServerAction, IMessage> {
        public IMessage onMessage(PacketServerAction message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                switch (message.action) {
                    case AIM: {
                        IPlayerData data = (IPlayerData)ctx.getServerHandler().field_147369_b.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                        data.setAiming(message.data);
                        data.sync((EntityPlayer)ctx.getServerHandler().field_147369_b);
                        break;
                    }
                    case RELOAD: {
                        GunBase gun;
                        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                        GunBase gunBase = gun = player.func_184614_ca().func_77973_b() instanceof GunBase ? (GunBase)player.func_184614_ca().func_77973_b() : null;
                        if (gun == null) break;
                        gun.getReloadType().handleReload((EntityPlayer)player);
                        break;
                    }
                    case NIGHT_VISION: {
                        IPlayerData data = (IPlayerData)ctx.getServerHandler().field_147369_b.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                        data.setNV(message.data);
                        break;
                    }
                }
            });
            return null;
        }
    }
}

