/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.network.sp;

import com.toma.pubgmc.util.helper.PacketHelper;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketParticle
implements IMessage {
    private EnumParticleTypes particle;
    private double x;
    private double y;
    private double z;
    private BlockPos hitBlock;
    private int amount;
    private ParticleAction action;
    private int parameter;
    private int additional;

    public PacketParticle() {
    }

    public PacketParticle(EnumParticleTypes particle, int amountOfParticles, double x, double y, double z, Block block, ParticleAction action, int par) {
        this(particle, amountOfParticles, x, y, z, new BlockPos(0, 0, 0), action, par);
        this.additional = Block.func_149682_b((Block)block);
    }

    public PacketParticle(EnumParticleTypes particle, int amountOfParticles, Vec3d hitVec, BlockPos block, ParticleAction action, int par) {
        this(particle, amountOfParticles, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, block, action, par);
    }

    public PacketParticle(EnumParticleTypes particle, int amountOfParticles, double x, double y, double z, BlockPos block, ParticleAction action, int par) {
        this.particle = particle;
        this.x = x;
        this.y = y;
        this.z = z;
        this.hitBlock = block;
        this.amount = amountOfParticles;
        this.action = action;
        this.parameter = par;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particle.ordinal());
        buf.writeInt(this.action.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        PacketHelper.writeBlockPos(this.hitBlock, buf);
        buf.writeInt(this.amount);
        buf.writeInt(this.parameter);
        buf.writeInt(this.additional);
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = EnumParticleTypes.values()[buf.readInt()];
        this.action = ParticleAction.values()[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.hitBlock = PacketHelper.readBlockPos(buf);
        this.amount = buf.readInt();
        this.parameter = buf.readInt();
        this.additional = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketParticle, IMessage> {
        public IMessage onMessage(PacketParticle message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
                    Random rand = new Random();
                    switch (message.action) {
                        case SPREAD_RANDOMLY: {
                            for (int i = 0; i < message.amount; ++i) {
                                world.func_175682_a(message.particle, true, message.x, message.y, message.z, rand.nextDouble() / 5.0, rand.nextDouble() / 5.0, rand.nextDouble() / 5.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(message.hitBlock))});
                            }
                            break;
                        }
                        case CREATE_LINE: {
                            Vec3d start = new Vec3d(message.x, message.y, message.z);
                            boolean eastWest = message.parameter > 0;
                            for (int i = 0; i < message.amount; ++i) {
                                world.func_175688_a(message.particle, eastWest ? start.field_72450_a + rand.nextDouble() : start.field_72450_a + 0.5, start.field_72448_b + 1.0, eastWest ? start.field_72449_c + 0.5 : start.field_72449_c + rand.nextDouble(), 0.0, -0.25, 0.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(message.hitBlock))});
                            }
                            break;
                        }
                        case HIT_EFFECT: {
                            for (int i = 0; i < message.amount; ++i) {
                                world.func_175682_a(message.particle, true, message.x, message.y, message.z, rand.nextDouble() / 5.0, rand.nextDouble() / 5.0, rand.nextDouble() / 5.0, new int[]{message.additional});
                            }
                            break;
                        }
                    }
                });
            }
            return null;
        }
    }

    public static enum ParticleAction {
        SPREAD_RANDOMLY,
        CREATE_LINE,
        HIT_EFFECT;

    }
}

