/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util;

public interface IBuilder<RESULT> {
    public RESULT build();

    default public void checkNotNull(Object obj) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(obj + " cannot be null!");
        }
    }

    default public void checkInt(int integer, int min, int max) throws IllegalArgumentException {
        if (integer > max || integer < min) {
            throw new IllegalArgumentException(integer + " doesn't fit into the <" + min + ";" + max + "> range!");
        }
    }

    default public void checkFloat(float floatValue, float min, float max) throws IllegalArgumentException {
        if (floatValue > max || floatValue < min) {
            throw new IllegalArgumentException(floatValue + " doesn't fit into the <" + min + ";" + max + "> range!");
        }
    }

    default public void checkDouble(double doubleValue, double min, double max) throws IllegalArgumentException {
        if (doubleValue > max || doubleValue < min) {
            throw new IllegalArgumentException(doubleValue + " doesn't fit into the <" + min + ";" + max + "> range!");
        }
    }

    default public void checkBoolean(boolean bool, boolean expectedValue) throws IllegalArgumentException {
        if (bool != expectedValue) {
            throw new IllegalArgumentException(bool + " is not equal the " + expectedValue);
        }
    }

    default public void checkBoolean(boolean bool) throws IllegalArgumentException {
        if (!bool) {
            throw new IllegalArgumentException(bool + " is not true!");
        }
    }
}

