/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.entity.EntityAirdrop;
import com.toma.pubgmc.common.entity.EntityVehicle;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketDelayedSound;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.RandomStringUtils;

public class PUBGMCUtil {
    public static NBTTagCompound createNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static void writeBasicEntityNBT(NBTTagCompound compound, Entity entity) {
        compound.func_74780_a("posX", entity.field_70165_t);
        compound.func_74780_a("posY", entity.field_70163_u);
        compound.func_74780_a("posZ", entity.field_70161_v);
        compound.func_74780_a("motionX", entity.field_70159_w);
        compound.func_74780_a("motionY", entity.field_70181_x);
        compound.func_74780_a("motionZ", entity.field_70179_y);
    }

    public static void readBasicEntityNBT(NBTTagCompound compound, Entity entity) {
        entity.field_70165_t = compound.func_74769_h("posX");
        entity.field_70163_u = compound.func_74769_h("posY");
        entity.field_70161_v = compound.func_74769_h("posZ");
        entity.field_70159_w = compound.func_74769_h("motionX");
        entity.field_70181_x = compound.func_74769_h("motionY");
        entity.field_70179_y = compound.func_74769_h("motionZ");
    }

    public static NBTTagCompound createWeaponNBT(ItemStack stack, int maxAmmo) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ammo", maxAmmo);
        compound.func_74757_a("isValidWeapon", true);
        stack.func_77982_d(compound);
        return compound;
    }

    public static NBTTagCompound clearNBTTag(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        stack.func_77982_d(compound);
        return compound;
    }

    public static void sendSoundPacket(SoundEvent event, float volume, BlockPos pos, NetworkRegistry.TargetPoint target) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketDelayedSound(event, volume, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), target);
    }

    public static boolean shouldSendCommandFeedback(World world) {
        return world.func_82736_K().func_82766_b("sendCommandFeedback");
    }

    public static boolean isPlayerDrivingVehicle(EntityPlayer player) {
        return player.func_184187_bx() instanceof EntityVehicle;
    }

    public static boolean isPlayerDriverOfVehicle(EntityPlayer player) {
        return player.func_184187_bx() instanceof EntityVehicle && player.func_184187_bx().func_184188_bt().get(0) == player;
    }

    public static <T> boolean contains(T object, T[] array) {
        for (T t : array) {
            if (object != t) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidNumber(String text) {
        char[] num = text.toCharArray();
        boolean valid = true;
        if (num[0] == '-' || Character.isDigit(num[0])) {
            for (int i = 0; i < num.length; ++i) {
                if (i <= 0 || Character.isDigit(num[i])) continue;
                valid = false;
            }
        }
        return valid;
    }

    public static boolean isStringDoubleOrFloat(String text) {
        char[] c = text.toCharArray();
        boolean valid = true;
        boolean alreadyUsedDot = false;
        for (int i = 0; i < c.length; ++i) {
            if (Character.isDigit(c[i]) || c[i] == '.') {
                if (alreadyUsedDot && c[i] == '.') {
                    valid = false;
                }
                if (c[i] != '.' || alreadyUsedDot) continue;
                alreadyUsedDot = true;
                continue;
            }
            valid = false;
        }
        return valid;
    }

    public static double getDistanceToBlockPos(BlockPos pos1, BlockPos pos2) {
        return Math.sqrt(PUBGMCUtil.sqr(Math.abs(pos1.func_177958_n() - pos2.func_177958_n())) + PUBGMCUtil.sqr(Math.abs(pos1.func_177952_p() - pos2.func_177952_p())));
    }

    public static double getDistanceToBlockPos3D(BlockPos pos1, BlockPos pos2) {
        return Math.sqrt(PUBGMCUtil.sqr(pos1.func_177958_n() - pos2.func_177958_n()) + PUBGMCUtil.sqr(pos1.func_177956_o() - pos2.func_177956_o()) + PUBGMCUtil.sqr(pos1.func_177952_p() - pos2.func_177952_p()));
    }

    public static boolean isMapSetupProperly(IGameData data) {
        boolean hasLocations;
        boolean properSize = data.getMapSize() > 0;
        boolean bl = hasLocations = !data.getSpawnLocations().isEmpty();
        if (!properSize) {
            Pubgmc.logger.error("Ivalid map size, setup your map!");
        }
        if (!hasLocations) {
            Pubgmc.logger.warn("No locations, add some! (Plane won't spawn)");
        }
        return properSize;
    }

    public static float getAngleBetween2Points(Entity entityToRotate, BlockPos targetPos) {
        float angle = (float)(MathHelper.func_181159_b((double)(entityToRotate.field_70161_v - (double)targetPos.func_177952_p()), (double)(entityToRotate.field_70165_t - (double)targetPos.func_177958_n())) * 57.29577951308232) - 90.0f;
        return angle;
    }

    public static float updateRotation(float prevRotation, float additionalRotation) {
        float f = MathHelper.func_76142_g((float)(additionalRotation - prevRotation));
        return f;
    }

    public static void updateEntityRotation(Entity entity, BlockPos targetPos) {
        entity.field_70177_z = PUBGMCUtil.updateRotation(entity.field_70177_z, PUBGMCUtil.getAngleBetween2Points(entity, targetPos));
    }

    public static double sqr(double num) {
        return num * num;
    }

    public static Vec3d getPositionVec(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static Vec3d getMotionVec(Entity entity) {
        Vec3d base = PUBGMCUtil.getPositionVec(entity);
        return new Vec3d(base.field_72450_a + entity.field_70159_w, base.field_72448_b + entity.field_70181_x, base.field_72449_c + entity.field_70179_y);
    }

    public static String generateID(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    public static void setModelPosition(ModelRenderer model, float x, float y, float z) {
        model.field_82906_o = x;
        model.field_82908_p = y;
        model.field_82907_q = z;
    }

    public static void setModelRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public static void spawnAirdrop(World world, BlockPos pos, boolean bigDrop) {
        if (!world.field_72995_K && world.func_175667_e(pos)) {
            EntityAirdrop drop = new EntityAirdrop(world, pos, bigDrop);
            world.func_72838_d((Entity)drop);
        }
    }

    public static float interpolate(float prev, float current, float partial) {
        return prev + partial * (current - prev);
    }

    public static double interpolate(double prev, double current, double partial) {
        return prev + partial * (current - prev);
    }

    public static Vec3d multiply(Vec3d vec, double amount) {
        return new Vec3d(vec.field_72450_a * amount, vec.field_72448_b * amount, vec.field_72449_c * amount);
    }
}

