/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.config.Config;

public final class VehicleConfiguration {
    @Config.Name(value="Max Health")
    @Config.Comment(value={"Vehicle maximum health"})
    @Config.RangeDouble(min=1.0, max=1500.0)
    @Config.RequiresWorldRestart
    public float maxHealth;
    @Config.Name(value="Max Speed")
    @Config.Comment(value={"Vehicle max speed"})
    @Config.RangeDouble(min=0.5, max=3.0)
    @Config.RequiresWorldRestart
    public float maxSpeed;
    @Config.Name(value="Acceleration")
    @Config.Comment(value={"Vehicle speed acceleration", "This also applies for braking, which is Acceleration*2"})
    @Config.RangeDouble(min=0.001, max=1.0)
    @Config.RequiresWorldRestart
    public float acceleration;
    @Config.Name(value="Turning Speed")
    @Config.Comment(value={"Turning angle increase per tick"})
    @Config.RangeDouble(min=0.1, max=1.0)
    @Config.RequiresWorldRestart
    public float turningSpeed;
    @Config.Name(value="Max Turning Angle")
    @Config.Comment(value={"Maximal angle at which can vehicle turn"})
    @Config.RangeDouble(min=1.0, max=10.0)
    public float maxTurningAngle;

    public VehicleConfiguration(float health, float speed, float angle, float acceleration, float turningAcceleration) {
        this.maxHealth = health;
        this.maxSpeed = speed;
        this.maxTurningAngle = angle;
        this.acceleration = acceleration;
        this.turningSpeed = turningAcceleration;
    }

    public static void writeBuffer(ByteBuf buf, VehicleConfiguration configuration) {
        buf.writeFloat(configuration.maxHealth);
        buf.writeFloat(configuration.maxSpeed);
        buf.writeFloat(configuration.acceleration);
        buf.writeFloat(configuration.turningSpeed);
        buf.writeFloat(configuration.maxTurningAngle);
    }

    public static VehicleConfiguration readBuffer(ByteBuf buf) {
        VehicleConfiguration cfg = new VehicleConfiguration(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        cfg.maxHealth = buf.readFloat();
        cfg.maxSpeed = buf.readFloat();
        cfg.acceleration = buf.readFloat();
        cfg.turningSpeed = buf.readFloat();
        cfg.maxTurningAngle = buf.readFloat();
        return cfg;
    }
}

