/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.game;

import com.google.common.base.Preconditions;
import com.toma.pubgmc.util.IBuilder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public final class ZoneSettings
implements INBTSerializable<NBTTagCompound> {
    public float damagePerSecond;
    public float speedModifier;
    public boolean isStatic;
    public boolean alwaysCentered;
    public int customSize = 0;
    public float[] shrinkModifiers = new float[7];

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("damage", this.damagePerSecond);
        nbt.func_74776_a("speed", this.speedModifier);
        nbt.func_74757_a("isStatic", this.isStatic);
        nbt.func_74757_a("centered", this.alwaysCentered);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.shrinkModifiers.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagFloat(this.shrinkModifiers[i]));
        }
        nbt.func_74782_a("modifiers", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.damagePerSecond = nbt.func_74760_g("damage");
        this.speedModifier = nbt.func_74760_g("speed");
        this.isStatic = nbt.func_74767_n("isStatic");
        this.alwaysCentered = nbt.func_74767_n("centered");
        this.shrinkModifiers = new float[7];
        NBTTagList list = nbt.func_150295_c("modifiers", 5);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.shrinkModifiers[i] = list.func_150308_e(i);
        }
    }

    public static final class Builder
    implements IBuilder<ZoneSettings> {
        int size;
        float dmg;
        float speed;
        boolean keepStatic = false;
        boolean centered = false;
        float[] floats = new float[]{0.7f, 0.4f, 0.24f, 0.1f, 0.036f, 0.016f, 0.002f};

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder damage(float damage) {
            this.dmg = damage;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder setStatic() {
            this.keepStatic = true;
            return this;
        }

        public Builder setAlwaysCentered() {
            this.centered = true;
            return this;
        }

        public Builder modifiers(float[] floats) {
            this.floats = floats;
            return this;
        }

        public Builder modifiers(float stage1, float stage2, float stage3, float stage4, float stage5, float stage6, float stage7) {
            this.floats[0] = stage1;
            this.floats[1] = stage2;
            this.floats[2] = stage3;
            this.floats[3] = stage4;
            this.floats[4] = stage5;
            this.floats[5] = stage6;
            this.floats[6] = stage7;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        @Override
        public ZoneSettings build() {
            if (this.keepStatic) {
                this.speed = 0.1f;
            }
            this.checkFloat(this.dmg, 0.1f, 15.0f);
            this.checkFloat(this.speed, 0.1f, 1.0f);
            this.checkBoolean(this.floats.length == 7);
            Preconditions.checkState((this.size >= 0 ? 1 : 0) != 0, (Object)"Zone size cannot be negative number!");
            ZoneSettings settings = new ZoneSettings();
            settings.damagePerSecond = this.dmg;
            settings.speedModifier = this.speed;
            settings.isStatic = this.keepStatic;
            settings.alwaysCentered = this.centered;
            settings.shrinkModifiers = this.floats;
            settings.customSize = this.size;
            return settings;
        }
    }
}

