/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.game.loot;

import com.toma.pubgmc.common.capability.IWorldData;
import com.toma.pubgmc.common.items.guns.AmmoType;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketSyncTileEntity;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.game.loot.ILootSpawner;
import com.toma.pubgmc.util.game.loot.LootOptions;
import com.toma.pubgmc.util.game.loot.LootType;
import com.toma.pubgmc.util.math.IWeight;
import com.toma.pubgmc.util.math.WeightedRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class LootManager {
    private static final HashMap<LootType, List<LootEntry>> MAP = new HashMap();
    private static final ArrayList<Item> SPECIAL_ATTACHMENTS = new ArrayList();
    private final World world;
    private final LootOptions loot;

    public LootManager(World world) {
        this.world = world;
        IWorldData worldData = (IWorldData)world.getCapability(IWorldData.WorldDataProvider.WORLD_DATA, null);
        this.loot = LootOptions.getCurrent(worldData);
    }

    public <T extends TileEntity> void generateLootIn(T spawner, int attempts) {
        NonNullList<ItemStack> inventory = ((ILootSpawner)spawner).getInventory();
        this.fillInventory(inventory, ((ILootSpawner)spawner).isAirdropContainer(), attempts);
        PacketHandler.sendToAllClients(new PacketSyncTileEntity(spawner.func_189515_b(new NBTTagCompound()), spawner.func_174877_v()));
    }

    public void fillInventory(NonNullList<ItemStack> inventory, boolean airdropStyle, int generatorRuns) {
        inventory.clear();
        Random random = new Random();
        if (airdropStyle) {
            int lastIndex = 0;
            for (int i = 0; i < generatorRuns; ++i) {
                lastIndex = this.generateAirdropLoot(inventory, lastIndex, random);
            }
            return;
        }
        int maxIndex = inventory.size();
        int currentIndex = 0;
        while (generatorRuns > 0 && currentIndex < maxIndex) {
            boolean flag;
            --generatorRuns;
            LootType type = WeightedRandom.getRandom(MAP.keySet());
            List<Object> entryList = new ArrayList(MAP.get(type));
            if (!this.loot.isSpecialLoot) {
                entryList = entryList.stream().filter(lootEntry -> !lootEntry.isSpecialLoot).collect(Collectors.toList());
            }
            boolean bl = flag = type == LootType.GUN;
            if (flag) {
                entryList = entryList.stream().filter(lootEntry -> ((LootEntry)lootEntry).stack.func_77973_b() instanceof GunBase && PUBGMCUtil.contains(((GunBase)((LootEntry)lootEntry).stack.func_77973_b()).getGunType(), this.loot.validWeaponTypes)).collect(Collectors.toList());
            }
            inventory.set(currentIndex, (Object)((LootEntry)WeightedRandom.getRandom(entryList, WeightedRandom.getTotalWeight(entryList), this.loot.chanceModifier)).get());
            ++currentIndex;
            if (!flag || !this.loot.genAmmo) continue;
            AmmoType ammoType = ((GunBase)((ItemStack)inventory.get(currentIndex - 1)).func_77973_b()).getAmmoType();
            int ammoSlots = maxIndex - currentIndex < 3 ? maxIndex - currentIndex : random.nextInt(3) + 1;
            for (int i = 0; i < ammoSlots; ++i) {
                inventory.set(currentIndex, (Object)new ItemStack(ammoType.ammo(), this.loot.randomAmmoGen ? random.nextInt(30) + 1 : 30));
                ++currentIndex;
            }
        }
    }

    private int generateAirdropLoot(NonNullList<ItemStack> inventory, int startingIndex, Random rand) {
        int i = startingIndex;
        inventory.set(i, (Object)new ItemStack(LootManager.getRandomObject(LootType.GUN, GunBase.GunType.values(), (byte)2)));
        int j = 1 + rand.nextInt(3);
        ItemStack stack = ((GunBase)((ItemStack)inventory.get(++i - 1)).func_77973_b()).getAmmoType().ammoStack();
        stack.func_190920_e(stack.func_77973_b() == PMCRegistry.PMCItems.AMMO_300M ? 5 : 30);
        for (int k = 0; k < j; ++k) {
            inventory.set(i, (Object)stack.func_77946_l());
            ++i;
        }
        LootManager.fillSpecialAttachmentList();
        inventory.set(i, (Object)new ItemStack(PMCRegistry.PMCItems.ARMOR3HELMET));
        inventory.set(++i, (Object)new ItemStack(PMCRegistry.PMCItems.ARMOR3BODY));
        inventory.set(++i, (Object)new ItemStack(PMCRegistry.PMCItems.BACKPACK3));
        ItemStack stack1 = new ItemStack(SPECIAL_ATTACHMENTS.get(rand.nextInt(SPECIAL_ATTACHMENTS.size())));
        inventory.set(++i, (Object)stack1);
        ++i;
        if (rand.nextInt(10) < 5) {
            Integer[] ints = ((IWorldData)this.world.getCapability(IWorldData.WorldDataProvider.WORLD_DATA, null)).getGhillieSuitsColorVariants().toArray(new Integer[0]);
            int color = ints.length == 0 ? 5429504 : ints[rand.nextInt(ints.length)];
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("ghillieColor", color);
            ItemStack stack2 = new ItemStack(PMCRegistry.PMCItems.GHILLIE_SUIT);
            stack2.func_77982_d(nbt);
            inventory.set(i, (Object)stack2);
            ++i;
        }
        return i;
    }

    private static void fillSpecialAttachmentList() {
        if (SPECIAL_ATTACHMENTS.isEmpty()) {
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.EXTENDED_MAG_AR);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.SCOPE4X);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.EXTENDED_MAG_SNIPER);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.COMPENSATOR_AR);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.SCOPE8X);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_AR);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.COMPENSATOR_SNIPER);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.EXTENDED_QUICKDRAW_MAG_SNIPER);
            SPECIAL_ATTACHMENTS.add(PMCRegistry.PMCItems.SCOPE15X);
        }
    }

    public static Item getRandomObject(LootType lootCategory, @Nullable GunBase.GunType[] allowedTypes, byte flag) {
        List<Object> entries = new ArrayList(MAP.get(lootCategory));
        if (allowedTypes != null) {
            entries = entries.stream().filter(e -> ((LootEntry)e).stack.func_77973_b() instanceof GunBase && PUBGMCUtil.contains(((GunBase)((LootEntry)e).stack.func_77973_b()).getGunType(), allowedTypes)).collect(Collectors.toList());
        }
        entries = entries.stream().filter(e -> flag == 0 ? !e.isSpecialLoot : (flag == 2 ? e.isSpecialLoot : e != null)).collect(Collectors.toList());
        return ((LootEntry)WeightedRandom.getRandom(entries)).stack.func_77973_b();
    }

    public static void register(LootType type, LootEntry entry) {
        MAP.get(type).add(entry);
    }

    public static void register(LootType type, Item item, int weight) {
        MAP.get(type).add(new LootEntry(item, weight));
    }

    public static Map<LootType, List<LootEntry>> getEntryMap() {
        return MAP;
    }

    static {
        for (LootType type : LootType.values()) {
            MAP.put(type, new ArrayList());
        }
    }

    public static class LootEntry
    implements IWeight {
        private final ItemStack stack;
        public final int weight;
        public final boolean isSpecialLoot;

        public LootEntry(Item item, int weight) {
            this(item, weight, false);
        }

        public LootEntry(Item item, int weight, boolean isSpecialLoot) {
            this(item, weight, isSpecialLoot, 1);
        }

        public LootEntry(Item item, int weight, boolean isSpecialLoot, int amount) {
            this.stack = new ItemStack(item, amount);
            this.weight = weight;
            this.isSpecialLoot = isSpecialLoot;
        }

        public ItemStack get() {
            return this.stack.func_77946_l();
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        public String toString() {
            return "LootEntry:[item=" + this.stack.toString() + ",weight=" + this.weight + ",specialLoot=" + this.isSpecialLoot + "]";
        }
    }
}

