/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.handlers;

import java.time.LocalDate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class CustomDateEvents {
    private static LocalDate date;

    public static void handleDates(EntityPlayer loggedPlayer) {
        date = LocalDate.now();
        if (CustomDateEvents.isChristmastTime()) {
            CustomDateEvents.message(loggedPlayer, TextFormatting.AQUA + "  * * * * * * * * * * * *  ", "From Toma, PUBGMC creator");
            CustomDateEvents.message(loggedPlayer, TextFormatting.AQUA + "* * * Merry Christmas * * *", "From Toma, PUBGMC creator");
            CustomDateEvents.message(loggedPlayer, TextFormatting.AQUA + "  * * * * * * * * * * * *  ", "From Toma, PUBGMC creator");
        } else if (CustomDateEvents.isNewYear()) {
            CustomDateEvents.message(loggedPlayer, TextFormatting.YELLOW + "[" + TextFormatting.GREEN + date.getYear() + TextFormatting.YELLOW + "] !!HAPPY NEW YEAR!! [" + TextFormatting.GREEN + date.getYear() + TextFormatting.YELLOW + "]");
        } else if (CustomDateEvents.is1stApril()) {
            CustomDateEvents.message(loggedPlayer, TextFormatting.RED + "It's april fools time! Don't believe anything, especially on internet!");
        } else if (CustomDateEvents.isPUBGMCAnniversary()) {
            int year = date.getYear() - 2018;
            String s = year == 1 ? "year" : "years";
            CustomDateEvents.message(loggedPlayer, TextFormatting.GOLD + "PUBGMC is now " + TextFormatting.ITALIC + year + TextFormatting.RESET + " " + TextFormatting.GOLD + s + " old! Thank you for your support! -Toma");
        }
    }

    private static boolean isChristmastTime() {
        int[] days = new int[]{24, 25, 26};
        return CustomDateEvents.isDate(days, 12);
    }

    private static boolean isNewYear() {
        return CustomDateEvents.isDate(1, 1);
    }

    private static boolean is1stApril() {
        return CustomDateEvents.isDate(1, 4);
    }

    private static boolean isPUBGMCAnniversary() {
        return CustomDateEvents.isDate(29, 6);
    }

    private static boolean isDate(int day, int month) {
        return date.getDayOfMonth() == day && date.getMonthValue() == month;
    }

    private static boolean isDate(int[] days, int month) {
        for (int day : days) {
            if (!CustomDateEvents.isDate(day, month)) continue;
            return true;
        }
        return false;
    }

    private static void message(EntityPlayer p, String message) {
        p.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private static void message(EntityPlayer p, String message, String hoverText) {
        TextComponentString s = new TextComponentString(message);
        s.func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(hoverText))));
        p.func_145747_a((ITextComponent)s);
    }
}

