/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.handlers;

import com.toma.pubgmc.common.entity.throwables.EntityFlashBang;
import com.toma.pubgmc.init.PMCSounds;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketUpdateFlashStatus;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.helper.ImageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class FlashHandler {
    public static final Map<UUID, Integer> FLASHED_PLAYERS = new HashMap<UUID, Integer>();
    public static final int MAX_FLASH_RANGE = 20;

    public static void flashPlayer(EntityPlayer player, EntityFlashBang from) {
        UUID uuid = player.func_110124_au();
        if (FlashHandler.isInRangeToFlash(player, from)) {
            int amount = FlashHandler.getFlashAmountFor(player, from);
            if (amount > 0) {
                FLASHED_PLAYERS.put(uuid, amount);
                if (player instanceof EntityPlayerMP) {
                    PacketHandler.sendToClient(new PacketUpdateFlashStatus(true), (EntityPlayerMP)player);
                }
            }
        } else if (FlashHandler.getFlashAmountFor(player, from) > 0) {
            player.func_184185_a(PMCSounds.flash_short, 10.0f, 1.0f);
        }
    }

    public static int getFlashAmountFor(EntityPlayer player, EntityFlashBang flash) {
        float f0 = (float)PUBGMCUtil.getDistanceToBlockPos3D(player.func_180425_c(), flash.func_180425_c());
        int amount = 180;
        if (f0 > 25.0f) {
            return 0;
        }
        if (f0 > 15.0f && f0 <= 25.0f) {
            amount = 1;
        }
        SoundEvent e = amount == 1 ? PMCSounds.flash_short : PMCSounds.flash;
        player.func_184185_a(e, 10.0f, 1.0f);
        return amount;
    }

    public static boolean isInRangeToFlash(EntityPlayer player, EntityFlashBang flash) {
        double d3;
        double d2;
        Vec3d playerPos = PUBGMCUtil.getPositionVec((Entity)player);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerLookNegativeYaw = playerPos.func_178787_e(playerLook.func_178785_b(-40.0f));
        Vec3d playerLookPositiveYaw = playerPos.func_178787_e(playerLook.func_178785_b(40.0f));
        Vec3d flashPos = PUBGMCUtil.getPositionVec(flash);
        double d0 = FlashHandler.area(playerPos, playerLookNegativeYaw, playerLookPositiveYaw) * 10000.0;
        double d1 = FlashHandler.area(flashPos, playerLookNegativeYaw, playerLookPositiveYaw) * 10000.0;
        return (int)d1 == (int)(d0 + (d2 = FlashHandler.area(playerPos, flashPos, playerLookPositiveYaw) * 10000.0) + (d3 = FlashHandler.area(playerPos, playerLookNegativeYaw, flashPos) * 10000.0));
    }

    private static double area(Vec3d yawNeg, Vec3d yawPos, Vec3d flash) {
        return Math.abs((yawNeg.field_72450_a * (yawPos.field_72449_c - flash.field_72449_c) + yawPos.field_72450_a * (flash.field_72449_c - yawNeg.field_72449_c) + flash.field_72450_a * (yawNeg.field_72449_c - yawPos.field_72449_c)) / 2.0);
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class ClientHandler {
        static final ResourceLocation FLASH = new ResourceLocation("pubgmc:textures/overlay/flash.png");
        static boolean blind = false;
        static int progress;

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void renderOverlay(RenderGameOverlayEvent.Post e) {
            if (blind || progress > 0) {
                if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                    Minecraft mc = Minecraft.func_71410_x();
                    ImageUtil.drawFullScreenImage(mc, e.getResolution(), FLASH, blind ? 1.0f : (float)progress / 100.0f);
                } else if (e.isCancelable()) {
                    e.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null && progress > 0) {
                --progress;
            }
        }

        public static void update(boolean b) {
            blind = b;
            if (!b) {
                progress = 100;
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ServerHandler {
        @SubscribeEvent
        public static void worldTick(TickEvent.WorldTickEvent e) {
            if (!FLASHED_PLAYERS.isEmpty()) {
                List list = FLASHED_PLAYERS.keySet().stream().filter(uuid -> e.world.func_152378_a(uuid) != null).collect(Collectors.toList());
                for (int i = 0; i < list.size(); ++i) {
                    UUID player = (UUID)list.get(i);
                    int amount = FLASHED_PLAYERS.get(player);
                    if (--amount > 0) {
                        FLASHED_PLAYERS.put(player, amount);
                        continue;
                    }
                    FLASHED_PLAYERS.remove(player);
                    EntityPlayer p = e.world.func_152378_a(player);
                    if (!(p instanceof EntityPlayerMP)) continue;
                    PacketHandler.sendToClient(new PacketUpdateFlashStatus(false), (EntityPlayerMP)p);
                }
            }
        }
    }
}

