/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.handlers;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.IGameTileEntity;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.tileentity.TileEntityPlayerCrate;
import com.toma.pubgmc.init.DamageSourceGun;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.util.math.ZonePos;
import com.toma.pubgmc.world.BlueZone;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class GameHandler {

    @Mod.EventBusSubscriber
    public static class Common {
        @SubscribeEvent
        public static void onTick(TickEvent.WorldTickEvent e) {
            if (e.phase == TickEvent.Phase.END) {
                return;
            }
            IGameData gameData = (IGameData)e.world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            if (!gameData.isPlaying()) {
                return;
            }
            Game game = gameData.getCurrentGame();
            if (gameData.isInactiveGame()) {
                return;
            }
            game.tickGame(e.world);
            if (game.gameTimer % 200 == 0 && game.canSpawnBots()) {
                int z;
                int y;
                BlueZone zone = game.zone;
                if (zone == null) {
                    return;
                }
                ZonePos min = zone.currentBounds.min();
                ZonePos max = zone.currentBounds.max();
                int maxDist = (int)Math.abs(max.x - min.x);
                int x = (int)min.x + e.world.field_73012_v.nextInt(maxDist);
                BlockPos pos = new BlockPos(x, y = e.world.func_189649_b(x, z = (int)min.z + e.world.field_73012_v.nextInt(maxDist)), z);
                if (!e.world.func_175667_e(pos)) {
                    List<EntityPlayer> playerList = game.getOnlinePlayers(e.world);
                    EntityPlayer player = playerList.get(e.world.field_73012_v.nextInt(playerList.size()));
                    x = (int)player.field_70165_t + e.world.field_73012_v.nextInt(64) - e.world.field_73012_v.nextInt(64);
                    pos = new BlockPos(x, y = e.world.func_189649_b(x, z = (int)player.field_70161_v + e.world.field_73012_v.nextInt(64) - e.world.field_73012_v.nextInt(64)), z);
                    if (!e.world.func_175667_e(pos)) {
                        return;
                    }
                }
                ++game.botsInGame;
                EntityAIPlayer aiPlayer = new EntityAIPlayer(e.world, pos);
                e.world.func_72838_d((Entity)aiPlayer);
                game.getLootDistributor().accept(aiPlayer);
            }
        }

        @SubscribeEvent
        public static void onChunkLoaded(ChunkEvent.Load e) {
            IGameData gameData = (IGameData)e.getWorld().getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            Game game = gameData.getCurrentGame();
            if (gameData == null || !gameData.isInactiveGame() || !game.shouldUpdateTileEntities()) {
                return;
            }
            Map map = e.getChunk().func_177434_r();
            for (TileEntity tileEntity : map.values()) {
                IGameTileEntity te;
                if (!(tileEntity instanceof IGameTileEntity) || (te = (IGameTileEntity)tileEntity).getGameHash().equals(gameData.getGameID())) continue;
                te.setGameHash(gameData.getGameID());
                try {
                    te.onLoaded();
                }
                catch (Exception ex) {
                    Pubgmc.logger.fatal("Fatal error occurred when updating {}, aborting update!", (Object)tileEntity);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerKilled(LivingDeathEvent e) {
            EntityLivingBase from;
            IGameData data = (IGameData)e.getEntity().field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            Game game = data.getCurrentGame();
            DamageSource source = e.getSource();
            EntityLivingBase entity = e.getEntityLiving();
            ItemStack gun = null;
            boolean wasHeadshot = false;
            if (!entity.field_70170_p.field_72995_K && entity instanceof EntityAIPlayer) {
                game.onBotDeath((EntityAIPlayer)entity);
                return;
            }
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            Pubgmc.proxy.resetMouseSens();
            if (game.getJoinedPlayers().contains(entity.func_110124_au())) {
                game.getJoinedPlayers().remove(entity.func_110124_au());
                game.updateDataToClients(entity.func_130014_f_());
            }
            if (source instanceof DamageSourceGun) {
                from = (EntityLivingBase)source.func_76346_g();
                gun = ((DamageSourceGun)source).getGun();
                wasHeadshot = ((DamageSourceGun)source).wasHeadshot();
            } else {
                from = source.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76346_g() : null;
            }
            EntityPlayer player = (EntityPlayer)entity;
            game.onPlayerKilled(player, from, gun, wasHeadshot);
            boolean createDeathCrate = game.shouldCreateDeathCrate();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() != PMCRegistry.PMCItems.IBLOCK) continue;
                stack.func_190920_e(0);
            }
            if (createDeathCrate && data.isPlaying()) {
                boolean canCreate;
                World world = player.field_70170_p;
                boolean bl = canCreate = !world.func_82736_K().func_82766_b("keepInventory") && !Common.isEmpty(player.field_71071_by);
                if (canCreate) {
                    BlockPos pos = null;
                    if (world.func_175623_d(player.func_180425_c())) {
                        pos = player.func_180425_c();
                    } else {
                        for (int y = 0; y <= 2 && pos == null; ++y) {
                            block2: for (int x = -2; x <= 2 && pos == null; ++x) {
                                for (int z = -2; z <= 2; ++z) {
                                    BlockPos p = new BlockPos(x, y, z);
                                    if (!world.func_175623_d(p)) continue;
                                    pos = p;
                                    continue block2;
                                }
                            }
                        }
                    }
                    Common.createAndFillDeathCrate(world, pos, player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent e) {
            IGameData gameData = (IGameData)e.player.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            Game game = gameData.getCurrentGame();
            boolean canRespawnIntoGame = game.respawnPlayer(e.player);
            if (canRespawnIntoGame) {
                game.getJoinedPlayers().add(e.player.func_110124_au());
                game.updateDataToClients(e.player.field_70170_p);
                ZonePos startPos = game.zone.currentBounds.min();
                int max = (int)Math.abs(startPos.x - game.zone.currentBounds.max().x);
                int x = (int)startPos.x + Pubgmc.rng().nextInt(max);
                int z = (int)startPos.z + Pubgmc.rng().nextInt(max);
                int y = e.player.field_70170_p.func_189649_b(x, z);
                e.player.func_70634_a((double)x, (double)y, (double)z);
            }
        }

        public static void createAndFillDeathCrate(World world, BlockPos pos, EntityPlayer player) {
            if (pos == null) {
                Pubgmc.logger.warn("Couldn't create death crate for {}", (Object)player.func_145748_c_());
                return;
            }
            world.func_175656_a(pos, PMCRegistry.PMCBlocks.PLAYER_CRATE.func_176223_P());
            TileEntityPlayerCrate te = (TileEntityPlayerCrate)world.func_175625_s(pos);
            if (te == null) {
                Pubgmc.logger.fatal("Exception occurred when creating player crate, tile entity is null!");
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                te.func_70299_a(i, stack.func_77946_l());
            }
            IPlayerData data = IPlayerData.PlayerData.get(player);
            int backpack = data.getBackpackLevel();
            if (backpack > 0) {
                te.func_70299_a(41, new ItemStack(backpack == 1 ? PMCRegistry.PMCItems.BACKPACK1 : (backpack == 2 ? PMCRegistry.PMCItems.BACKPACK2 : PMCRegistry.PMCItems.BACKPACK3)));
            }
            if (data.getEquippedNV()) {
                te.func_70299_a(42, new ItemStack((Item)PMCRegistry.PMCItems.NV_GOGGLES));
            }
            player.field_71071_by.func_174888_l();
        }

        public static boolean isEmpty(InventoryPlayer inv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() == PMCRegistry.PMCItems.IBLOCK) continue;
                return false;
            }
            return true;
        }
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void onRenderOverlay(RenderGameOverlayEvent.Post e) {
            IGameData gameData;
            if (e.getType() == RenderGameOverlayEvent.ElementType.ALL && (gameData = (IGameData)Minecraft.func_71410_x().field_71441_e.getCapability(IGameData.GameDataProvider.GAMEDATA, null)).isPlaying() && !gameData.isInactiveGame()) {
                gameData.getCurrentGame().renderGameInfo(e.getResolution());
            }
        }
    }
}

