/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.math;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.util.math.IWeight;
import java.util.Collection;
import java.util.List;

public final class WeightedRandom {
    public static int getTotalWeight(Collection<? extends IWeight> collection) {
        int total = 0;
        for (IWeight iWeight : collection) {
            total += iWeight.getWeight();
        }
        return total;
    }

    public static <T extends IWeight> T getRandom(Collection<T> collection) {
        return WeightedRandom.getRandom(collection, WeightedRandom.getTotalWeight(collection));
    }

    public static <T extends IWeight> T getRandom(Collection<T> collection, int totalWeight) {
        if (totalWeight <= 0) {
            throw new IllegalArgumentException("Total weight must be > 0!");
        }
        int weight = Pubgmc.rng().nextInt(totalWeight);
        for (IWeight t : collection) {
            if (!((double)(weight -= t.getWeight()) < 0.0)) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends IWeight> T getRandom(List<T> collection, int totalWeight, double modifier) {
        if (totalWeight <= 0) {
            throw new IllegalArgumentException("Total weight must be > 0!");
        }
        double weight = Pubgmc.rng().nextInt(totalWeight);
        for (int i = collection.size() - 1; i >= 0; --i) {
            IWeight t = (IWeight)collection.get(i);
            if (!((weight -= (double)t.getWeight() * modifier) < 0.0)) continue;
            return (T)t;
        }
        return null;
    }
}

