/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.math;

import com.toma.pubgmc.util.math.ZonePos;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ZoneBounds {
    private ZonePos min;
    private ZonePos max;

    public ZoneBounds(ZonePos min, ZonePos max) {
        this.min = min;
        this.max = max;
    }

    public ZoneBounds(double x1, double z1, double x2, double z2) {
        this(new ZonePos(x1, z1), new ZonePos(x2, z2));
    }

    public ZoneBounds(ZoneBounds zone) {
        this(zone.min.x, zone.min.z, zone.max.x, zone.max.z);
    }

    public void shrink(double x, double z, double xn, double zn) {
        this.min.add(x, z);
        this.max.subtract(xn, zn);
    }

    public ZonePos min() {
        return this.min;
    }

    public ZonePos max() {
        return this.max;
    }

    public String toString() {
        return "ZoneBounds[min=" + this.min.toString() + ",max=" + this.max.toString() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ZoneBounds) {
            ZoneBounds bounds = (ZoneBounds)obj;
            return bounds.min.equals(this.min) && bounds.max.equals(this.max);
        }
        return false;
    }

    public static NBTTagCompound toNBT(ZoneBounds zoneBounds) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("min", (NBTBase)ZonePos.toNBT(zoneBounds.min));
        nbt.func_74782_a("max", (NBTBase)ZonePos.toNBT(zoneBounds.max));
        return nbt;
    }

    public static ZoneBounds fromNBT(NBTTagCompound nbt) {
        ZonePos min = ZonePos.fromNBT(nbt.func_74775_l("min"));
        ZonePos max = ZonePos.fromNBT(nbt.func_74775_l("max"));
        return new ZoneBounds(min, max);
    }
}

