/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.math;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class ZonePos {
    public double x;
    public double z;

    public ZonePos(double x, double z) {
        this.x = x;
        this.z = z;
    }

    public ZonePos add(double x, double z) {
        this.x += x;
        this.z += z;
        return this;
    }

    public ZonePos add(double f) {
        return this.add(f, f);
    }

    public ZonePos subtract(double x, double z) {
        return this.add(-x, -z);
    }

    public ZonePos subtract(double f) {
        return this.subtract(f, f);
    }

    public ZonePos multiply(double x, double z) {
        this.x *= x;
        this.z *= z;
        return this;
    }

    public ZonePos multiply(double f) {
        return this.multiply(f, f);
    }

    public ZonePos divide(double x, double z) {
        return this.multiply(1.0 / x, 1.0 / z);
    }

    public ZonePos divide(double f) {
        return this.multiply(1.0 / f);
    }

    public double distanceX(ZonePos pos) {
        return this.x - pos.x;
    }

    public double distanceZ(ZonePos pos) {
        return this.z - pos.z;
    }

    public double distance(ZonePos pos) {
        double x = this.distanceX(pos);
        double z = this.distanceZ(pos);
        return MathHelper.func_76133_a((double)(x * x + z * z));
    }

    public String toString() {
        return "Zone:[x=" + this.x + ",z=" + this.z + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ZonePos) {
            ZonePos pos = (ZonePos)obj;
            return pos.x == this.x && pos.z == this.z;
        }
        return false;
    }

    public static NBTTagCompound toNBT(ZonePos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("x", pos.x);
        tag.func_74780_a("z", pos.z);
        return tag;
    }

    public static ZonePos fromNBT(NBTTagCompound nbt) {
        double x = nbt.func_74769_h("x");
        double z = nbt.func_74769_h("z");
        return new ZonePos(x, z);
    }
}

