/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.recipes;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.util.helper.ImageUtil;
import com.toma.pubgmc.util.recipes.ICraftingInventory;
import com.toma.pubgmc.util.recipes.PMCIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PMCRecipe {
    public static final ResourceLocation TEXTURE = new ResourceLocation("pubgmc:textures/gui/recipebase.png");
    public final Item result;
    public final int resultCount;
    public final PMCIngredient[] ingredients;
    public final CraftingCategory category;
    public final ItemStack returnStack;

    protected PMCRecipe(Item result, int amount, PMCIngredient[] ingredients, CraftingCategory category) {
        this(result, amount, ingredients, category, ItemStack.field_190927_a);
    }

    protected PMCRecipe(Item result, PMCIngredient[] ingredients, CraftingCategory category, ItemStack returnStack) {
        this(result, 1, ingredients, category, returnStack);
    }

    protected PMCRecipe(Item result, int amount, PMCIngredient[] ingredients, CraftingCategory category, ItemStack returnStack) {
        this.result = result;
        this.resultCount = amount;
        this.ingredients = ingredients;
        this.category = category;
        this.returnStack = returnStack;
    }

    public static boolean isRecipeReady(PMCRecipe recipe, ICraftingInventory inv) {
        if (recipe == null || recipe.ingredients.length == 0) {
            return false;
        }
        for (PMCIngredient ingredient : recipe.ingredients) {
            ItemStack stack = inv.func_70301_a(ingredient.slotIndex);
            if (!stack.func_190926_b() && stack.func_77973_b() == ingredient.getIngredient().func_77973_b() && stack.func_190916_E() >= ingredient.getIngredient().func_190916_E()) continue;
            return false;
        }
        return true;
    }

    public static boolean areSameRecipes(PMCRecipe r1, PMCRecipe r2) {
        if (r1.ingredients.length != r2.ingredients.length) {
            return false;
        }
        for (int i = 0; i < r1.ingredients.length; ++i) {
            PMCIngredient i1 = r1.ingredients[i];
            PMCIngredient i2 = r2.ingredients[i];
            if (i1.getIngredient() != i2.getIngredient() || i1.slotIndex != i2.slotIndex || i1.getIngredient().func_190916_E() != i2.getIngredient().func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public void onCraft(World world, BlockPos pos) {
        if (!this.returnStack.func_190926_b() && !world.field_72995_K) {
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, new ItemStack(this.returnStack.func_77973_b()));
            item.func_70016_h(Pubgmc.rng().nextDouble() * 0.15, Pubgmc.rng().nextDouble() * 0.15, Pubgmc.rng().nextDouble() * 0.15);
            item.func_174867_a(30);
            world.func_72838_d((Entity)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawRecipe(int mouseX, int mouseY) {
        ImageUtil.drawCustomSizedImage(Minecraft.func_71410_x(), TEXTURE, mouseX, mouseY, 50.0, 86.0, false);
        for (PMCIngredient ing : this.ingredients) {
            int x = ing.slotIndex % 2 == 0 ? mouseX + 8 : mouseX + 26;
            int y = ing.slotIndex / 2 * 18 + mouseY + 8;
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_175042_a(ing.getIngredient(), x, y);
            RenderHelper.func_74518_a();
            boolean flag = ing.getIngredient().func_190916_E() >= 10;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(ing.getIngredient().func_190916_E() + "", flag ? (float)(x + 5) : (float)(x + 11), (float)(y + 9), 0xFFFFFF);
        }
    }

    public static enum CraftingCategory {
        GUNS("Guns"),
        AMMO("Ammo"),
        ATTACHMENTS("Attachments"),
        HEALS("Healing"),
        THROWABLES("Grenades"),
        WEARABLES("Armor&Utility"),
        VEHICLES("Vehicles");

        private final String name;

        private CraftingCategory(String name) {
            this.name = name;
        }

        public static CraftingCategory getNextCategory(CraftingCategory current) {
            int i = current.ordinal();
            return i + 1 == CraftingCategory.values().length ? CraftingCategory.values()[0] : CraftingCategory.values()[i + 1];
        }

        public static CraftingCategory getPrevCategory(CraftingCategory current) {
            int i = current.ordinal();
            return i > 0 ? CraftingCategory.values()[i - 1] : CraftingCategory.values()[CraftingCategory.values().length - 1];
        }

        public String getCategoryName() {
            return this.name;
        }
    }
}

