/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.util.recipes;

import com.google.common.base.Preconditions;
import com.toma.pubgmc.util.recipes.PMCIngredient;
import com.toma.pubgmc.util.recipes.PMCRecipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PMCRecipeBuilder {
    private Item result = null;
    private int amount = 1;
    private Item returnItem = Items.field_190931_a;
    private ArrayList<PMCIngredient> ingredients = new ArrayList();
    private PMCRecipe.CraftingCategory category;
    private int slotIndex = 0;

    private PMCRecipeBuilder() {
    }

    public static PMCRecipeBuilder createGun() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.GUNS);
    }

    public static PMCRecipeBuilder createAmmo() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.AMMO);
    }

    public static PMCRecipeBuilder createAttachment() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.ATTACHMENTS);
    }

    public static PMCRecipeBuilder createHeal() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.HEALS);
    }

    public static PMCRecipeBuilder createGrenade() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.THROWABLES);
    }

    public static PMCRecipeBuilder createWearable() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.WEARABLES);
    }

    public static PMCRecipeBuilder createVehicle() {
        return PMCRecipeBuilder.create(PMCRecipe.CraftingCategory.VEHICLES);
    }

    private static PMCRecipeBuilder create(PMCRecipe.CraftingCategory category) {
        PMCRecipeBuilder builder = new PMCRecipeBuilder();
        builder.category = category;
        return builder;
    }

    public PMCRecipeBuilder result(Item item) {
        this.result = item;
        return this;
    }

    public PMCRecipeBuilder ingredient(Item item, int amount) {
        this.ingredients.add(new PMCIngredient(this.slotIndex, item, amount));
        ++this.slotIndex;
        return this;
    }

    public PMCRecipeBuilder ingredient(Block block, int amount) {
        this.ingredients.add(new PMCIngredient(this.slotIndex, block, amount));
        ++this.slotIndex;
        return this;
    }

    public PMCRecipeBuilder ingredient(Item item, int amount, int meta) {
        this.ingredients.add(new PMCIngredient(this.slotIndex, item, amount, meta));
        ++this.slotIndex;
        return this;
    }

    public PMCRecipeBuilder ingredient(Block block, int amount, int meta) {
        this.ingredients.add(new PMCIngredient(this.slotIndex, block, amount, meta));
        ++this.slotIndex;
        return this;
    }

    public PMCRecipeBuilder returns(Item item) {
        this.returnItem = item;
        return this;
    }

    public PMCRecipeBuilder resultAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public PMCRecipe build() {
        Preconditions.checkNotNull((Object)this.result);
        Preconditions.checkState((this.amount > 0 && this.amount <= 64 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)this.category));
        Preconditions.checkState((!this.ingredients.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.result != null && this.result != Items.field_190931_a ? 1 : 0) != 0);
        PMCIngredient[] ingredient = this.ingredients.toArray(new PMCIngredient[0]);
        return this.returnItem == Items.field_190931_a ? new PMCRecipe(this.result, this.amount, ingredient, this.category) : new PMCRecipe(this.result, this.amount, ingredient, this.category, new ItemStack(this.returnItem));
    }
}

