/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.world;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.entity.EntityPlane;
import com.toma.pubgmc.init.PMCDamageSources;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.game.ZoneSettings;
import com.toma.pubgmc.util.math.ZoneBounds;
import com.toma.pubgmc.util.math.ZonePos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class BlueZone {
    private ZoneSettings settings;
    public ZoneBounds prevBounds;
    public ZoneBounds currentBounds;
    public ZoneBounds nextBounds;
    public int currentStage;
    public BlockPos origin;
    private boolean shrinking;
    private double shrinkX;
    private double shrinkZ;
    private double shrinkXn;
    private double shrinkZn;
    private float currentDamageMultiplier;

    public BlueZone() {
        this(0, new BlockPos(0, 0, 0), ZoneSettings.Builder.create().speed(0.1f).damage(0.1f).build());
    }

    public BlueZone(int mapSize, BlockPos center, ZoneSettings settings) {
        boolean flag;
        this.settings = settings;
        boolean bl = flag = settings.customSize > 0;
        if (flag) {
            center = new BlockPos(center.func_177958_n() - mapSize + settings.customSize + Pubgmc.rng().nextInt(1 + mapSize * 2 - settings.customSize * 2), 256, center.func_177952_p() - mapSize + settings.customSize + Pubgmc.rng().nextInt(1 + mapSize * 2 - settings.customSize * 2));
            mapSize = settings.customSize;
        }
        this.origin = center;
        this.currentBounds = new ZoneBounds(center.func_177958_n() - mapSize, center.func_177952_p() - mapSize, center.func_177958_n() + mapSize, center.func_177952_p() + mapSize);
        this.prevBounds = new ZoneBounds(this.currentBounds);
        this.currentDamageMultiplier = settings.damagePerSecond;
    }

    public BlueZone(IGameData gameData, ZoneSettings settings) {
        this(gameData.getMapSize(), gameData.getMapCenter(), settings);
    }

    public void notifyFirstZoneCreation(World world) {
        if (this.nextBounds == null) {
            this.calculateNextZone(world);
            ++this.currentStage;
        }
    }

    public void shrink() {
        if (this.settings.isStatic) {
            Pubgmc.logger.warn("Attempted to shrink bluezone which has static size!");
            return;
        }
        if (this.nextBounds == null) {
            Pubgmc.logger.error("Cannot shrink zone, since it doesn't know where to shrink! Call 'BlueZone#notifyFirstZoneCreation' first!");
            return;
        }
        this.shrinking = true;
    }

    public void bluezoneTick(World world) {
        IGameData gameData = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        Game game = gameData.getCurrentGame();
        this.prevBounds = new ZoneBounds(this.currentBounds);
        if (game.getGameTimer() % 20 == 0) {
            this.damagePlayersOutsideZone(world);
        }
        if (this.shrinking) {
            if (this.currentStage == 7 && game.getJoinedPlayers().size() < 2) {
                game.notifyAllPlayers(world, TextFormatting.ITALIC + "Match finished!");
                game.stopGame(world);
            }
            this.shrinkCurrentZone(world);
        }
    }

    public boolean isShrinking() {
        return this.shrinking;
    }

    public double minX(double partialTicks) {
        return PUBGMCUtil.interpolate(this.prevBounds.min().x, this.currentBounds.min().x, partialTicks);
    }

    public double minZ(double partialTicks) {
        return PUBGMCUtil.interpolate(this.prevBounds.min().z, this.currentBounds.min().z, partialTicks);
    }

    public double maxX(double partialTicks) {
        return PUBGMCUtil.interpolate(this.prevBounds.max().x, this.currentBounds.max().x, partialTicks);
    }

    public double maxZ(double partialTicks) {
        return PUBGMCUtil.interpolate(this.prevBounds.max().z, this.currentBounds.max().z, partialTicks);
    }

    public double getClosestDistance(double x, double z) {
        double startx = x - this.minX(1.0);
        double endx = this.maxX(1.0) - x;
        double startz = z - this.minZ(1.0);
        double endz = this.maxZ(1.0) - z;
        double min = Math.min(startx, endx);
        min = Math.min(min, endx);
        return Math.min(min, startz);
    }

    public double getClosestDistance(Entity entity) {
        return this.getClosestDistance(entity.field_70165_t, entity.field_70161_v);
    }

    public boolean isInsideZone(Entity entity) {
        ZonePos min = this.currentBounds.min();
        ZonePos max = this.currentBounds.max();
        return entity.field_70165_t >= min.x && entity.field_70165_t <= max.x && entity.field_70161_v >= min.z && entity.field_70161_v <= max.z;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("settings", (NBTBase)this.settings.serializeNBT());
        nbt.func_74782_a("origin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.origin));
        nbt.func_74768_a("stage", this.currentStage);
        nbt.func_74757_a("shrinking", this.shrinking);
        nbt.func_74782_a("current", (NBTBase)ZoneBounds.toNBT(this.currentBounds));
        nbt.func_74782_a("prev", (NBTBase)ZoneBounds.toNBT(this.prevBounds == null ? this.currentBounds : this.prevBounds));
        nbt.func_74780_a("xMin", this.shrinkX);
        nbt.func_74780_a("zMin", this.shrinkZ);
        nbt.func_74780_a("xMax", this.shrinkXn);
        nbt.func_74780_a("zMax", this.shrinkZn);
        if (this.nextBounds != null) {
            nbt.func_74782_a("planned", (NBTBase)ZoneBounds.toNBT(this.nextBounds));
        }
        return nbt;
    }

    public static BlueZone fromNBT(NBTTagCompound nbt) {
        ZoneSettings settings = new ZoneSettings();
        settings.deserializeNBT(nbt.func_74775_l("settings"));
        BlueZone zone = new BlueZone();
        zone.settings = settings;
        zone.origin = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("origin"));
        zone.currentStage = nbt.func_74762_e("stage");
        zone.shrinking = nbt.func_74767_n("shrinking");
        zone.currentBounds = ZoneBounds.fromNBT(nbt.func_74775_l("current"));
        zone.prevBounds = ZoneBounds.fromNBT(nbt.func_74775_l("prev"));
        zone.shrinkX = nbt.func_74769_h("xMin");
        zone.shrinkZ = nbt.func_74769_h("zMin");
        zone.shrinkXn = nbt.func_74769_h("xMax");
        zone.shrinkZn = nbt.func_74769_h("zMax");
        zone.currentDamageMultiplier = (float)((double)zone.settings.damagePerSecond * Math.pow(2.0, zone.currentStage));
        if (nbt.func_74764_b("planned")) {
            zone.nextBounds = ZoneBounds.fromNBT(nbt.func_74775_l("planned"));
        }
        return zone;
    }

    protected void damagePlayersOutsideZone(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            boolean inLobby = ((IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null)).getLobby().isInLobby(player);
            boolean inPlane = player.func_184218_aH() && player.func_184187_bx() instanceof EntityPlane;
            if (inPlane || inLobby || this.isInsideZone((Entity)player) || player.func_190530_aW()) continue;
            player.func_70097_a(PMCDamageSources.ZONE, this.currentDamageMultiplier);
        }
    }

    protected void onShrinkingFinished(World world) {
        this.shrinking = false;
        this.currentBounds = new ZoneBounds(this.nextBounds);
        if (this.currentStage < 7) {
            this.calculateNextZone(world);
            ++this.currentStage;
        } else {
            ZonePos prevStart = this.currentBounds.min();
            ZonePos prevEnd = this.currentBounds.max();
            int xCenter = (int)(prevEnd.x - prevStart.x) / 2;
            int zCenter = (int)(prevEnd.z - prevStart.z) / 2;
            ZonePos centered = new ZonePos(xCenter, zCenter);
            ZonePos centerStartModified = new ZonePos(centered.x - 0.25, centered.z - 0.25);
            ZonePos centerEndModified = new ZonePos(centered.x + 0.25, centered.z + 0.25);
            this.nextBounds = new ZoneBounds(centerStartModified, centerEndModified);
        }
        this.currentDamageMultiplier = (float)((double)this.settings.damagePerSecond * Math.pow(2.0, this.currentStage));
    }

    private void calculateNextZone(World world) {
        float modifier = this.settings.shrinkModifiers[this.currentStage];
        int newDiameter = (int)((float)((IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null)).getMapSize() * modifier);
        if (this.settings.alwaysCentered) {
            ZonePos start = new ZonePos(this.origin.func_177958_n() - newDiameter, this.origin.func_177952_p() - newDiameter);
            ZonePos end = new ZonePos(this.origin.func_177958_n() + newDiameter, this.origin.func_177952_p() + newDiameter);
            this.nextBounds = new ZoneBounds(start, end);
        } else {
            ZonePos startPoint = this.currentBounds.min();
            ZonePos endPoint = this.currentBounds.max();
            int xMax = (int)Math.abs(endPoint.x - startPoint.x - (double)(newDiameter * 2));
            int zMax = (int)Math.abs(endPoint.z - startPoint.z - (double)(newDiameter * 2));
            int x = Pubgmc.rng().nextInt(Math.abs(xMax));
            int z = Pubgmc.rng().nextInt(Math.abs(zMax));
            ZonePos newStartPoint = new ZonePos(startPoint.x + (double)x, startPoint.z + (double)z);
            ZonePos newEndPoint = new ZonePos(newStartPoint.x + (double)(newDiameter * 2), newStartPoint.z + (double)(newDiameter * 2));
            this.nextBounds = new ZoneBounds(newStartPoint, newEndPoint);
        }
        this.calculateShrinkModifiers();
    }

    private void shrinkCurrentZone(World world) {
        this.currentBounds.shrink(this.shrinkX, this.shrinkZ, this.shrinkXn, this.shrinkZn);
        if (this.hasZoneArrivedToFinalPos()) {
            this.onShrinkingFinished(world);
        }
    }

    private boolean hasZoneArrivedToFinalPos() {
        ZonePos movingMin = this.currentBounds.min();
        ZonePos nextMin = this.nextBounds.min();
        ZonePos movingMax = this.currentBounds.max();
        ZonePos nextMax = this.nextBounds.max();
        boolean b0 = movingMin.x >= nextMin.x;
        boolean b1 = movingMin.z >= nextMin.z;
        boolean b2 = movingMax.x <= nextMax.x;
        boolean b3 = movingMax.z <= nextMax.z;
        return b0 && b1 && b2 && b3;
    }

    private void calculateShrinkModifiers() {
        boolean zs;
        float base = this.settings.speedModifier;
        double d0 = Math.abs(this.nextBounds.min().x - this.currentBounds.min().x);
        double d1 = Math.abs(this.nextBounds.min().z - this.currentBounds.min().z);
        double d2 = Math.abs(this.currentBounds.max().x - this.nextBounds.max().x);
        double d3 = Math.abs(this.currentBounds.max().z - this.nextBounds.max().z);
        boolean isXDiffBigger = Math.abs(d2 - d0) >= Math.abs(d3 - d1);
        boolean xs = d0 <= d2;
        boolean bl = zs = d1 <= d3;
        if (isXDiffBigger) {
            if (xs) {
                this.shrinkX = Math.abs((double)base * d0 / d2);
                this.shrinkZ = Math.abs((double)base * d1 / d2);
                this.shrinkXn = base;
                this.shrinkZn = Math.abs((double)base * d3 / d2);
            } else {
                this.shrinkX = base;
                this.shrinkZ = Math.abs((double)base * d1 / d0);
                this.shrinkXn = Math.abs((double)base * d2 / d0);
                this.shrinkZn = Math.abs((double)base * d3 / d0);
            }
        } else if (zs) {
            this.shrinkX = Math.abs((double)base * d0 / d3);
            this.shrinkZ = Math.abs((double)base * d1 / d3);
            this.shrinkXn = Math.abs((double)base * d2 / d3);
            this.shrinkZn = base;
        } else {
            this.shrinkX = Math.abs((double)base * d0 / d1);
            this.shrinkZ = base;
            this.shrinkXn = Math.abs((double)base * d2 / d1);
            this.shrinkZn = Math.abs((double)base * d3 / d1);
        }
    }
}

