/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.world;

import com.toma.pubgmc.common.capability.IGameData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class MapLocation
implements INBTSerializable<NBTTagCompound> {
    private String name;
    private BlockPos pos;

    public MapLocation(String name, BlockPos pos) {
        this.name = name;
        this.pos = pos;
    }

    public String name() {
        return this.name;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("position"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapLocation) {
            MapLocation map = (MapLocation)obj;
            return this.name.equalsIgnoreCase(map.name) && this.pos.func_177958_n() == map.pos.func_177958_n() && this.pos.func_177952_p() == map.pos.func_177952_p();
        }
        return false;
    }

    public static MapLocation findLocation(String name, IGameData gameData) {
        for (MapLocation location : gameData.getSpawnLocations()) {
            if (!location.name().equalsIgnoreCase(name)) continue;
            return location;
        }
        return null;
    }

    public String toString() {
        return "Name: " + this.name + ", Position [" + this.pos.func_177958_n() + ", " + this.pos.func_177956_o() + ", " + this.pos.func_177952_p() + "]";
    }
}

