/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.world;

import com.google.common.base.Predicate;
import com.toma.pubgmc.init.PMCRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGen
implements IWorldGenerator {
    private WorldGenerator copper = new WorldGenMinable(PMCRegistry.PMCBlocks.COPPER_ORE.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOre(this.copper, world, random, chunkX, chunkZ, 5, 10, 40);
    }

    private void generateOre(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 256) {
            throw new IllegalArgumentException(generator + " cannot be generated outside world bounds!");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = minHeight + random.nextInt(heightDiff);
            int z = chunkZ * 16 + random.nextInt(16);
            generator.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

