/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.chatbubbles;

import com.mamiyaotaru.chatbubbles.ChatBubbleMessage;
import com.mamiyaotaru.chatbubbles.ChatBubbles;
import com.mamiyaotaru.chatbubbles.GLShim;
import com.mojang.blaze3d.platform.GLX;
import java.util.ArrayList;
import net.minecraft.class_1007;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_742;
import net.minecraft.class_898;

public class RenderPlayerChatBubbles
extends class_1007 {
    ArrayList<ChatBubbleMessage> relevantMessages;
    float r = 0.0f;
    float g = 0.0f;
    float b = 0.0f;
    int lineWidth = 4;

    public RenderPlayerChatBubbles(class_898 renderManager) {
        this(renderManager, false);
    }

    public RenderPlayerChatBubbles(class_898 renderManager, boolean smallArms) {
        super(renderManager, smallArms);
        System.out.println("**Chat Bubble Renderer Initialized**");
        this.relevantMessages = new ArrayList();
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    public void method_4041(class_742 par1EntityLivingBase, double par2, double par4, double par6) {
        super.method_4041((class_1309)par1EntityLivingBase, par2, par4, par6);
        if (par1EntityLivingBase != this.field_4676.field_4686.method_19331()) {
            try {
                String myName = this.scrubCodes(par1EntityLivingBase.method_5477().method_10851());
                if (myName.length() > 0) {
                    this.r = (128.0f + (float)(myName.charAt(0) % 32 * 4)) / 256.0f;
                }
                if (myName.length() > 1) {
                    this.g = (128.0f + (float)(myName.charAt(1) % 32 * 4)) / 256.0f;
                }
                if (myName.length() > 2) {
                    this.b = (128.0f + (float)(myName.charAt(2) % 32 * 4)) / 256.0f;
                }
                int currentTime = ChatBubbles.instance.game.field_1705.method_1738();
                this.relevantMessages = ChatBubbles.instance.getMessagesByAuthor(myName);
                int lines = 2;
                for (ChatBubbleMessage message : this.relevantMessages) {
                    String[] messageLines = message.getMessageLines();
                    float remainingTime = ChatBubbles.instance.MESSAGELIFETIME - (currentTime - message.getUpdatedCounter());
                    this.renderMessage(lines, messageLines, remainingTime, (class_1657)par1EntityLivingBase, par2, par4, par6);
                    lines = lines + messageLines.length + 1;
                }
            }
            catch (Exception e) {
                System.out.println("***Exception in bubbleRenderer***: " + e);
            }
        }
    }

    protected void renderMessage(int lines, String[] message, float remainingTime, class_1657 par1EntityPlayer, double par2, double par4, double par6) {
        double var10 = par1EntityPlayer.method_5858(this.field_4676.field_4686.method_19331());
        float var12 = par1EntityPlayer.method_5715() ? 32.0f : 64.0f;
        int brightness = 0xF000F0;
        int brightMod = brightness % 65536;
        int brightDiv = brightness / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)((float)brightMod / 1.0f), (float)((float)brightDiv / 1.0f));
        if (var10 <= (double)(var12 * var12)) {
            class_327 fontRenderer = this.field_4676.method_3949();
            float var13 = 1.6f;
            float var14 = 0.016666668f * var13;
            GLShim.glPushMatrix();
            GLShim.glTranslatef((float)par2 + 0.0f, (float)par4 + 2.3f, (float)par6);
            GLShim.glNormal3f(0.0f, 1.0f, 0.0f);
            GLShim.glRotatef(-this.field_4676.field_4679, 0.0f, 1.0f, 0.0f);
            GLShim.glRotatef(this.field_4676.field_4677, 1.0f, 0.0f, 0.0f);
            GLShim.glScalef(-var14, -var14, var14);
            GLShim.glDisable(2896);
            GLShim.glDisable(2912);
            GLShim.glDepthMask(false);
            GLShim.glEnable(3042);
            GLShim.glBlendFunc(770, 771);
            int maxWidth = 8;
            for (int t = message.length - 1; t >= 0; --t) {
                int var17 = fontRenderer.method_1727(message[t]) / 2;
                if (var17 <= maxWidth) continue;
                maxWidth = var17;
            }
            int left = -maxWidth + 1;
            int right = maxWidth;
            class_289 var15 = class_289.method_1348();
            int top = -(lines + message.length - 1) * 9 + 2;
            int bottom = -lines * 9 + 6;
            float alphaFadeFactor = 1.0f;
            if (remainingTime < 20.0f) {
                alphaFadeFactor = remainingTime / 20.0f;
                alphaFadeFactor *= alphaFadeFactor;
            }
            GLShim.glEnable(32823);
            GLShim.glPolygonOffset(1.0f, 5.0f);
            GLShim.glEnable(3553);
            GLShim.glDisable(2929);
            this.drawBubble(1.0f, 1.0f, 1.0f, Math.min(alphaFadeFactor, 0.25f), top, bottom, left, right, var15, 5.0f);
            GLShim.glPolygonOffset(1.0f, 3.0f);
            GLShim.glEnable(2929);
            GLShim.glDepthMask(true);
            this.drawBubble(this.r, this.g, this.b, alphaFadeFactor, top, bottom, left, right, var15, 3.0f);
            for (int t = message.length - 1; t >= 0; --t) {
                GLShim.glPolygonOffset(1.0f, 1.0f);
                GLShim.glDisable(2929);
                int var16 = -lines * 9;
                alphaFadeFactor = Math.max(alphaFadeFactor, 0.016f);
                int textFade = (int)(alphaFadeFactor * 255.0f);
                int textFadeBG = Math.min(textFade, 127) << 24;
                fontRenderer.method_1729(message[t], (float)(-maxWidth), (float)var16, textFadeBG);
                GLShim.glEnable(2929);
                GLShim.glDepthMask(true);
                fontRenderer.method_1729(message[t], (float)(-maxWidth), (float)var16, textFade <<= 24);
                ++lines;
            }
            GLShim.glDisable(32823);
            GLShim.glEnable(2912);
            GLShim.glEnable(2896);
            GLShim.glDisable(3042);
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLShim.glPopMatrix();
        }
    }

    private void drawBubble(float r, float g, float b, float a, float top, float bottom, float left, float right, class_289 var15, float offset) {
        this.img("images/chatbubble.png");
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)left, (double)top, 0.0).method_1312(0.0625, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)bottom, 0.0).method_1312(0.0625, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)bottom, 0.0).method_1312(0.9375, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)top, 0.0).method_1312(0.9375, 0.125).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)top, 0.0).method_1312(0.0, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)bottom, 0.0).method_1312(0.0, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)bottom, 0.0).method_1312(0.0625, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)top, 0.0).method_1312(0.0625, 0.125).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)right, (double)top, 0.0).method_1312(0.9375, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)bottom, 0.0).method_1312(0.9375, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)bottom, 0.0).method_1312(1.0, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)top, 0.0).method_1312(1.0, 0.125).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)left, (double)(top - (float)this.lineWidth), 0.0).method_1312(0.0625, 0.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)top, 0.0).method_1312(0.0625, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)top, 0.0).method_1312(0.9375, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)(top - (float)this.lineWidth), 0.0).method_1312(0.9375, 0.0).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)left, (double)bottom, 0.0).method_1312(0.0625, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.0625, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(-2.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.5, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(-2.0, (double)bottom, 0.0).method_1312(0.5, 0.875).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315(-2.0, (double)bottom, 0.0).method_1312(0.5, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(-2.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.5, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(6.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.625, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(6.0, (double)bottom, 0.0).method_1312(0.625, 0.875).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315(6.0, (double)bottom, 0.0).method_1312(0.625, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(6.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.625, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.9375, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)bottom, 0.0).method_1312(0.9375, 0.875).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)(top - (float)this.lineWidth), 0.0).method_1313(0, 0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)top, 0.0).method_1312(0.0, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)top, 0.0).method_1312(0.0625, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)(top - (float)this.lineWidth), 0.0).method_1312(0.0625, 0.0).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)right, (double)(top - (float)this.lineWidth), 0.0).method_1312(0.9375, 0.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)top, 0.0).method_1312(0.9375, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)top, 0.0).method_1312(1.0, 0.125).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)(top - (float)this.lineWidth), 0.0).method_1313(1, 0).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)bottom, 0.0).method_1312(0.0, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(left - (float)this.lineWidth), (double)(bottom + (float)this.lineWidth), 0.0).method_1313(0, 1).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.0625, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)left, (double)bottom, 0.0).method_1312(0.0625, 0.875).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315((double)right, (double)bottom, 0.0).method_1312(0.9375, 0.875).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)right, (double)(bottom + (float)this.lineWidth), 0.0).method_1312(0.9375, 1.0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)(bottom + (float)this.lineWidth), 0.0).method_1313(1, 1).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315((double)(right + (float)this.lineWidth), (double)bottom, 0.0).method_1312(1.0, 0.875).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
        GLShim.glPolygonOffset(1.0f, offset - 1.0f);
        this.img("images/chatbubbletail.png");
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_1315(-2.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1313(0, 0).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(-2.0, (double)(bottom + (float)this.lineWidth + 8.0f), 0.0).method_1313(0, 1).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(6.0, (double)(bottom + (float)this.lineWidth + 8.0f), 0.0).method_1313(1, 1).method_1336(r, g, b, a).method_1344();
        vertexBuffer.method_1315(6.0, (double)(bottom + (float)this.lineWidth), 0.0).method_1313(1, 0).method_1336(r, g, b, a).method_1344();
        var15.method_1350();
    }

    public void img(String paramStr) {
        this.field_4676.field_4685.method_4618(new class_2960("chatbubbles", paramStr));
    }
}

