/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.rift;

import com.chocohead.rift.ClassMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class MappingBlob
implements Serializable {
    private static final long serialVersionUID = 1807933665347803447L;
    public final Map<String, ClassMapping> mappings;
    public final Map<String, String> nameBridge;

    public MappingBlob(Map<String, ClassMapping> mappings) {
        this.mappings = Collections.unmodifiableMap(mappings);
        this.nameBridge = Collections.unmodifiableMap(mappings.entrySet().parallelStream().collect(Collectors.toMap(mapping -> ((ClassMapping)mapping.getValue()).mcpName, Map.Entry::getKey)));
    }

    public void write(File out) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(out));){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serialising mapping blob", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappingBlob read(File file) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            MappingBlob mappingBlob = (MappingBlob)ois.readObject();
            return mappingBlob;
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserialising mapping blob", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible?", e);
        }
    }
}

