/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.accesstransform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dimdev.accesstransform.AccessLevel;
import org.dimdev.accesstransform.ElementReference;

public class AccessTransformationSet {
    private final Map<ElementReference, AccessLevel> transformations = new HashMap<ElementReference, AccessLevel>();
    private final Set<String> affectedClasses = new HashSet<String>();

    public void addMimimumAccessLevel(ElementReference elementReference, AccessLevel accessLevel) {
        this.transformations.put(elementReference, AccessLevel.union(this.transformations.get(elementReference), accessLevel));
        this.affectedClasses.add(elementReference.kind == ElementReference.Kind.CLASS ? elementReference.name : elementReference.owner);
    }

    public void addMinimumAccessLevel(String string) {
        if ((string = string.trim()).isEmpty() || string.startsWith("#")) {
            return;
        }
        int indexOfFirstSpace = string.indexOf(32);
        String accessLevel = string.substring(0, indexOfFirstSpace);
        String elementReference = string.substring(indexOfFirstSpace + 1);
        this.addMimimumAccessLevel(ElementReference.fromString(elementReference), AccessLevel.fromString(accessLevel));
    }

    public AccessLevel getMinimumAccessLevel(ElementReference elementReference) {
        return this.transformations.get(elementReference);
    }

    public boolean isClassAffected(String name) {
        return this.affectedClasses.contains(name);
    }

    public boolean isEmpty() {
        return this.transformations.size() == 0;
    }
}

