/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.riftloader;

import com.chocohead.rift.ClassMapping;
import com.chocohead.rift.MappingBlob;
import com.chocohead.rift.RemappingClassAdapter;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.dimdev.utils.ReflectionUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class OptifineDevTransformer
implements IClassTransformer {
    private final ZipFile vanilla;
    private final IClassTransformer transformer;
    private final MappingBlob mappings;

    public OptifineDevTransformer() {
        File vanilla = new File(System.getProperty("vanilla-jar", System.getProperty("user.home") + "/.gradle/caches/minecraft/net/minecraft/minecraft/1.13.2/minecraft-1.13.2.jar"));
        if (!vanilla.exists() || !vanilla.isFile()) {
            throw new IllegalStateException("Unable to find vanilla jar at " + vanilla);
        }
        try {
            this.vanilla = new JarFile(vanilla);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open vanilla jar at " + vanilla, e);
        }
        try {
            this.transformer = (IClassTransformer)Launch.classLoader.findClass("optifine.OptiFineClassTransformer").newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error creating Optifine class transformer", e);
        }
        File mappings = new File(System.getProperty("mappings", "NONE-PROVIDED"));
        if (!mappings.exists() || !mappings.isFile()) {
            throw new IllegalStateException("Unable to find mappings at " + vanilla);
        }
        MappingBlob temp = MappingBlob.read(mappings);
        HashMap<String, ClassMapping> map = new HashMap<String, ClassMapping>(temp.mappings);
        OptifineDevTransformer.addOptifineExtension(map, "net/optifine/render/AabbFrame", "cea");
        OptifineDevTransformer.addOptifineExtension(map, "net/optifine/override/ChunkCacheOF", "aye");
        OptifineDevTransformer.addOptifineExtension(map, "net/optifine/override/PlayerControllerOF", "crf");
        OptifineDevTransformer.addOptifineExtension(map, "net/optifine/gui/GuiScreenOF", "ckd");
        this.mappings = new MappingBlob(map);
        try {
            ReflectionUtils.addURLToClasspath(vanilla.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error putting vanilla jar on classpath", e);
        }
    }

    private static void addOptifineExtension(Map<String, ClassMapping> map, String optiClass, String notchClass) {
        ClassMapping aabbFrame = new ClassMapping(optiClass, optiClass);
        aabbFrame.methods.putAll(map.get((Object)notchClass).methods);
        aabbFrame.fields.putAll(map.get((Object)notchClass).fields);
        map.put(optiClass, aabbFrame);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ZipEntry entry;
        String notch = this.mappings.nameBridge.get(name.replace('.', '/'));
        if (notch != null && (entry = this.vanilla.getEntry(notch + ".class")) != null) {
            try {
                byte[] vanillaClass = ByteStreams.toByteArray((InputStream)this.vanilla.getInputStream(entry));
                byte[] optiClass = this.transformer.transform(notch, name, vanillaClass);
                if (optiClass != vanillaClass) {
                    ClassNode optiNode = this.toDeobfClassNode(optiClass);
                    ClassWriter classWriter = new ClassWriter(0);
                    optiNode.accept((ClassVisitor)classWriter);
                    return classWriter.toByteArray();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Getting Optifine version of " + name, e);
            }
        }
        return basicClass;
    }

    private ClassNode toDeobfClassNode(byte[] code) {
        ClassNode transformedNode = new ClassNode();
        new ClassReader(code).accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)transformedNode, this.mappings), 8);
        return transformedNode;
    }
}

