/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings;

import java.util.function.Consumer;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.apparatus.SimpleFlightApparatus;
import me.paulf.wings.server.config.WingsItemsConfig;
import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.server.dreamcatcher.Playable;
import me.paulf.wings.server.fix.WingsFixes;
import me.paulf.wings.server.flight.ConstructWingsAccessorEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.FlightDefault;
import me.paulf.wings.server.net.Network;
import me.paulf.wings.server.net.clientbound.MessageSetWingSettings;
import me.paulf.wings.server.net.clientbound.MessageSyncFlight;
import me.paulf.wings.util.CapabilityProviders;
import me.paulf.wings.util.ItemAccessor;
import me.paulf.wings.util.ModConfigSaver;
import me.paulf.wings.util.SimpleStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public abstract class Proxy {
    protected final Network network = new Network();
    private ItemAccessor<EntityLivingBase> wingsAccessor = ItemAccessor.none();

    public void preinit() {
        CapabilityManager.INSTANCE.register(Flight.class, SimpleStorage.ofVoid(), FlightDefault::new);
        CapabilityManager.INSTANCE.register(FlightApparatus.class, SimpleStorage.ofVoid(), SimpleFlightApparatus.builder()::build);
        CapabilityManager.INSTANCE.register(InSomniable.class, SimpleStorage.ofVoid(), InSomniable::new);
        CapabilityManager.INSTANCE.register(Playable.class, SimpleStorage.ofVoid(), Playable::new);
        WingsFixes.register();
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onClientConnectedEvent(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
                ((NetHandlerPlayServer)event.getHandler()).func_147359_a(Proxy.this.network.createPacket(new MessageSetWingSettings(WingsItemsConfig.createWingAttributes())));
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)ModConfigSaver.create("wings"));
    }

    protected void init() {
        ConstructWingsAccessorEvent event = new ConstructWingsAccessorEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.wingsAccessor = event.build();
    }

    public void addFlightListeners(EntityPlayer player, Flight instance) {
        if (player instanceof EntityPlayerMP) {
            instance.registerFlyingListener(isFlying -> {
                player.field_71075_bZ.field_75101_c = isFlying;
            });
            instance.registerFlyingListener(isFlying -> {
                if (isFlying) {
                    player.func_184210_p();
                }
            });
            Flight.Notifier notifier = Flight.Notifier.of(() -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (EntityPlayerMP)player), p -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (EntityPlayerMP)p), () -> this.network.sendToAllTracking(new MessageSyncFlight(player, instance), (Entity)player));
            instance.registerSyncListener(players -> players.notify(notifier));
        }
    }

    public final ItemAccessor<EntityLivingBase> getWingsAccessor() {
        return this.wingsAccessor;
    }

    public abstract Consumer<CapabilityProviders.CompositeBuilder> createAvianWings(String var1);

    public abstract Consumer<CapabilityProviders.CompositeBuilder> createInsectoidWings(String var1);
}

