/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.paulf.wings.Proxy;
import me.paulf.wings.client.apparatus.FlightApparatusView;
import me.paulf.wings.client.apparatus.FlightApparatusViews;
import me.paulf.wings.client.apparatus.WingForm;
import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.client.flight.AnimatorAvian;
import me.paulf.wings.client.flight.AnimatorInsectoid;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.model.ModelWings;
import me.paulf.wings.client.model.ModelWingsAvian;
import me.paulf.wings.client.model.ModelWingsInsectoid;
import me.paulf.wings.client.renderer.LayerWings;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.net.serverbound.MessageControlFlying;
import me.paulf.wings.util.CapabilityProviders;
import me.paulf.wings.util.KeyInputListener;
import me.paulf.wings.util.SimpleStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;

public final class ClientProxy
extends Proxy {
    private final ModelWings<AnimatorAvian> avianWings = new ModelWingsAvian();
    private final ModelWings<AnimatorInsectoid> insectoidWings = new ModelWingsInsectoid();

    @Override
    public void preinit() {
        super.preinit();
        CapabilityManager.INSTANCE.register(FlightView.class, SimpleStorage.ofVoid(), () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(FlightApparatusView.class, SimpleStorage.ofVoid(), () -> {
            throw new UnsupportedOperationException();
        });
        MinecraftForge.EVENT_BUS.register((Object)KeyInputListener.builder().category("key.categories.wings").key("key.wings.fly", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 19).onPress(() -> {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Flight flight = Flights.get((EntityPlayer)player);
            if (flight != null && flight.canFly((EntityPlayer)player)) {
                flight.toggleIsFlying(Flight.PlayerSet.ofOthers());
            }
        }).build());
    }

    @Override
    protected void init() {
        super.init();
        Minecraft mc = Minecraft.func_71410_x();
        ItemColors colors = mc.getItemColors();
        colors.func_186730_a((stack, pass) -> pass == 0 ? 10164013 : 0xFFFFFF, new Item[]{WingsItems.BAT_BLOOD});
        RenderManager manager = mc.func_175598_ae();
        Stream.concat(manager.getSkinMap().values().stream(), manager.field_78729_o.values().stream()).filter(RenderLivingBase.class::isInstance).map(RenderLivingBase.class::cast).filter(render -> render.func_177087_b() instanceof ModelBiped).forEach(render -> {
            ModelRenderer body = ((ModelBiped)render.func_177087_b()).field_78115_e;
            render.func_177094_a((LayerRenderer)new LayerWings((RenderLivingBase<?>)render, (player, scale) -> {
                if (player.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                body.func_78794_c(scale);
            }));
        });
    }

    @Override
    public void addFlightListeners(EntityPlayer player, Flight flight) {
        super.addFlightListeners(player, flight);
        if (player.func_175144_cb()) {
            Flight.Notifier notifier = Flight.Notifier.of(() -> {}, p -> {}, () -> this.network.sendToServer(new MessageControlFlying(flight.isFlying())));
            flight.registerSyncListener(players -> players.notify(notifier));
        }
    }

    @Override
    public Consumer<CapabilityProviders.CompositeBuilder> createAvianWings(String name) {
        return this.createWings(name, AnimatorAvian::new, this.avianWings);
    }

    @Override
    public Consumer<CapabilityProviders.CompositeBuilder> createInsectoidWings(String name) {
        return this.createWings(name, AnimatorInsectoid::new, this.insectoidWings);
    }

    private <A extends Animator> Consumer<CapabilityProviders.CompositeBuilder> createWings(String name, Supplier<A> animator, ModelWings<A> model) {
        WingForm form = WingForm.of(animator, model, new ResourceLocation("wings", String.format("textures/entity/wings/%s.png", name)));
        return builder -> builder.add(FlightApparatusViews.providerBuilder(FlightApparatusViews.create(form)).build());
    }
}

