/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import me.paulf.wings.server.block.WingsBlocks;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.util.Util;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="wings")
public final class WingsModels {
    private WingsModels() {
    }

    @SubscribeEvent
    public static void onRegister(ModelRegistryEvent event) {
        WingsModels.bindAll(WingsItems.ANGEL_WINGS);
        WingsModels.bindAll(WingsItems.SLIME_WINGS);
        WingsModels.bindAll(WingsItems.BLUE_BUTTERFLY_WINGS);
        WingsModels.bindAll(WingsItems.MONARCH_BUTTERFLY_WINGS);
        WingsModels.bindAll(WingsItems.FIRE_WINGS);
        WingsModels.bindAll(WingsItems.BAT_WINGS);
        WingsModels.bindAll(WingsItems.FAIRY_WINGS);
        WingsModels.bindAll(WingsItems.EVIL_WINGS);
        WingsModels.bindAll(WingsItems.DRAGON_WINGS);
        WingsModels.bindOne(WingsBlocks.FAIRY_DUST_ORE);
        WingsModels.bindOne(WingsBlocks.AMETHYST_ORE);
        WingsModels.bindOne(WingsItems.FAIRY_DUST);
        WingsModels.bindOne(WingsItems.AMETHYST);
        WingsModels.bindOne(WingsItems.BAT_BLOOD);
    }

    private static void bindOne(Block block) {
        WingsModels.bindOne((Item)ForgeRegistries.ITEMS.getValue(Util.getName(block)));
    }

    private static void bindAll(Item item) {
        ModelResourceLocation location = WingsModels.createInventoryLocation(item);
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> location);
    }

    private static void bindOne(Item item) {
        WingsModels.bind(item, 0, WingsModels.createInventoryLocation(item));
    }

    private static void bind(Item item, int meta, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    private static ModelResourceLocation createInventoryLocation(Item item) {
        return new ModelResourceLocation(Util.getName(item), "inventory");
    }
}

