/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.asm;

import me.paulf.wings.server.asm.GetCameraEyeHeightEvent;
import me.paulf.wings.server.asm.GetLivingHeadLimitEvent;
import me.paulf.wings.server.asm.PlayerFlightCheckEvent;
import me.paulf.wings.server.asm.PlayerFlownEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class WingsHooks {
    private WingsHooks() {
    }

    public static boolean onFlightCheck(EntityPlayer player, boolean defaultValue) {
        PlayerFlightCheckEvent ev = new PlayerFlightCheckEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && defaultValue;
    }

    public static float onGetCameraEyeHeight(Entity entity, float delta) {
        GetCameraEyeHeightEvent ev = GetCameraEyeHeightEvent.create(entity, delta);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static void onUpdateBodyRotation(EntityLivingBase living, float movementYaw) {
        living.field_70761_aq += MathHelper.func_76142_g((float)(movementYaw - living.field_70761_aq)) * 0.3f;
        GetLivingHeadLimitEvent ev = GetLivingHeadLimitEvent.create(living);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        float hLimit = ev.getHardLimit();
        float sLimit = ev.getSoftLimit();
        float theta = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(living.field_70177_z - living.field_70761_aq)), (float)(-hLimit), (float)hLimit);
        living.field_70761_aq = living.field_70177_z - theta;
        if (theta * theta > sLimit * sLimit) {
            living.field_70761_aq += theta * 0.2f;
        }
    }

    public static void onAddFlown(EntityPlayer player, double x, double y, double z) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerFlownEvent(player, new Vec3d(x, y, z)));
    }

    public static boolean onReplaceItemSlotCheck(Item item, ItemStack stack) {
        return item instanceof ItemElytra || item.getEquipmentSlot(stack) != null;
    }
}

