/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.dreamcatcher;

import java.util.UUID;
import java.util.function.Consumer;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.nbt.NBTTagCompound;

public final class Playable {
    private State state;

    public Playable() {
        this(AbsentState.INSTANCE);
    }

    private Playable(State state) {
        this.state = state;
    }

    public void setPlayer(UUID player) {
        this.state = new PresentState(player);
    }

    public void ifPlayerPresent(Consumer<UUID> consumer) {
        this.state.ifPresent(consumer);
    }

    public static final class Serializer
    implements NBTSerializer<Playable, NBTTagCompound> {
        private static final String PLAYER_UUID = "PlayerUUID";

        @Override
        public NBTTagCompound serialize(Playable instance) {
            NBTTagCompound compound = new NBTTagCompound();
            instance.ifPlayerPresent(playerId -> compound.func_186854_a(PLAYER_UUID, playerId));
            return compound;
        }

        @Override
        public Playable deserialize(NBTTagCompound compound) {
            Playable playable = new Playable();
            if (compound.func_186855_b(PLAYER_UUID)) {
                playable.setPlayer(compound.func_186857_a(PLAYER_UUID));
            }
            return playable;
        }
    }

    private static final class PresentState
    implements State {
        private final UUID player;

        private PresentState(UUID player) {
            this.player = player;
        }

        @Override
        public void ifPresent(Consumer<UUID> consumer) {
            consumer.accept(this.player);
        }
    }

    private static final class AbsentState
    implements State {
        private static final State INSTANCE = new AbsentState();

        private AbsentState() {
        }

        @Override
        public void ifPresent(Consumer<UUID> consumer) {
        }
    }

    private static interface State {
        public void ifPresent(Consumer<UUID> var1);
    }
}

