/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.flight.AttachFlightCapabilityEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.FlightDefault;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="wings")
public final class Flights {
    private static final CapabilityHolder<EntityPlayer, Flight, CapabilityHolder.State<EntityPlayer, Flight>> HOLDER = CapabilityHolder.create();

    private Flights() {
    }

    public static boolean has(EntityPlayer player) {
        return HOLDER.state().has(player, null);
    }

    @Nullable
    public static Flight get(EntityPlayer player) {
        return HOLDER.state().get(player, null);
    }

    @CapabilityInject(value=Flight.class)
    static void inject(Capability<Flight> capability) {
        HOLDER.inject(capability);
    }

    public static void ifPlayer(Entity entity, BiConsumer<EntityPlayer, Flight> action) {
        Flights.ifPlayer(entity, e -> true, action);
    }

    public static void ifPlayer(Entity entity, Predicate<EntityPlayer> condition, BiConsumer<EntityPlayer, Flight> action) {
        EntityPlayer player;
        Flight flight;
        if (entity instanceof EntityPlayer && (flight = Flights.get(player = (EntityPlayer)entity)) != null && condition.test(player)) {
            action.accept(player, flight);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer) {
            Supplier<FlightDefault> factory = () -> {
                FlightDefault flight = new FlightDefault();
                WingsMod.instance().addFlightListeners((EntityPlayer)entity, flight);
                return flight;
            };
            FlightDefault flight = factory.get();
            event.addCapability(new ResourceLocation("wings", "flight"), HOLDER.state().providerBuilder(flight).serializedBy(new FlightDefault.Serializer(factory)).build());
            MinecraftForge.EVENT_BUS.post((Event)AttachFlightCapabilityEvent.create(event, flight));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Flight newInstance;
        Flight oldInstance = Flights.get(event.getOriginal());
        if (oldInstance != null && (newInstance = Flights.get(event.getEntityPlayer())) != null) {
            oldInstance.clone(newInstance);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Flight flight = Flights.get(event.player);
        if (flight != null) {
            flight.sync(Flight.PlayerSet.ofSelf());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Flight flight = Flights.get(event.player);
        if (flight != null) {
            flight.sync(Flight.PlayerSet.ofSelf());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Flight flight = Flights.get(event.player);
        if (flight != null) {
            flight.sync(Flight.PlayerSet.ofSelf());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Flights.ifPlayer(event.getTarget(), (player, flight) -> flight.sync(Flight.PlayerSet.ofPlayer((EntityPlayerMP)event.getEntityPlayer())));
    }
}

