/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.net.clientbound;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import me.paulf.wings.server.item.ImmutableWingSettings;
import me.paulf.wings.server.item.ItemWings;
import me.paulf.wings.server.item.WingSettings;
import me.paulf.wings.server.net.Message;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class MessageSetWingSettings
extends Message {
    private ImmutableMap<ResourceLocation, WingSettings> settings;

    public MessageSetWingSettings() {
    }

    public MessageSetWingSettings(ImmutableMap<ResourceLocation, WingSettings> settings) {
        this.settings = settings;
    }

    @Override
    protected void serialize(PacketBuffer buf) {
        ImmutableSet entries = this.settings.entrySet();
        buf.writeInt(entries.size());
        for (Map.Entry entry : entries) {
            buf.func_192572_a((ResourceLocation)entry.getKey());
            WingSettings value = (WingSettings)entry.getValue();
            buf.writeInt(value.getRequiredFlightSatiation());
            buf.writeFloat(value.getFlyingExertion());
            buf.writeInt(value.getRequiredLandSatiation());
            buf.writeFloat(value.getLandingExertion());
            buf.writeShort(value.getItemDurability());
        }
    }

    @Override
    protected void deserialize(PacketBuffer buf) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int remaining = buf.readInt();
        while (remaining-- > 0) {
            builder.put((Object)buf.func_192575_l(), (Object)ImmutableWingSettings.of(buf.readInt(), buf.readFloat(), buf.readInt(), buf.readFloat(), buf.readShort()));
        }
        this.settings = builder.build();
    }

    @Override
    protected void process(MessageContext ctx) {
        for (Map.Entry entry : this.settings.entrySet()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey());
            if (!(item instanceof ItemWings)) continue;
            ((ItemWings)item).setSettings((WingSettings)entry.getValue());
        }
    }
}

