/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.world;

import java.util.Random;
import java.util.function.Supplier;
import me.paulf.wings.server.block.WingsBlocks;
import me.paulf.wings.server.config.VeinSettings;
import me.paulf.wings.server.config.WingsOreConfig;
import me.paulf.wings.server.world.feature.FeatureRange;
import me.paulf.wings.server.world.feature.FeatureVein;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wings")
public final class GenerationHandler {
    private static final WorldGenerator FAIRY_DUST_ORE_GENERATOR = GenerationHandler.newVeinFeature(WingsOreConfig.FAIRY_DUST, () -> ((Block)WingsBlocks.FAIRY_DUST_ORE).func_176223_P());
    private static final WorldGenerator AMETHYST_ORE_GENERATOR = GenerationHandler.newVeinFeature(WingsOreConfig.AMETHYST, () -> ((Block)WingsBlocks.AMETHYST_ORE).func_176223_P());

    private GenerationHandler() {
    }

    @SubscribeEvent
    public static void onDecorateBiome(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        Random rng = event.getRand();
        BlockPos pos = event.getChunkPos().func_180331_a(8, 0, 8);
        FAIRY_DUST_ORE_GENERATOR.func_180709_b(world, rng, pos);
        AMETHYST_ORE_GENERATOR.func_180709_b(world, rng, pos);
    }

    private static WorldGenerator newVeinFeature(VeinSettings settings, Supplier<IBlockState> block) {
        return new FeatureRange(new FeatureVein(block, settings.getSize()), settings.getCount(), settings.getMinHeight(), settings.getMaxHeight());
    }
}

