/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

public final class CubicBezier {
    private static final float NEWTON_ITERATIONS = 4.0f;
    private static final float NEWTON_MIN_SLOPE = 0.001f;
    private static final float SUBDIVISION_PRECISION = 1.0E-7f;
    private static final float SUBDIVISION_MAX_ITERATIONS = 10.0f;
    private static final int SPLINE_TABLE_SIZE = 11;
    private static final float SAMPLE_STEP_SIZE = 0.1f;
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final float[] sampleValues;

    public CubicBezier(float x1, float y1, float x2, float y2) {
        this(x1, y1, x2, y2, CubicBezier.createSampleValues(x1, x2));
    }

    private CubicBezier(float x1, float y1, float x2, float y2, float[] sampleValues) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.sampleValues = sampleValues;
    }

    public float eval(float x) {
        if (this.x1 == this.y1 && this.x2 == this.y2) {
            return x;
        }
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        return CubicBezier.calcBezier(this.getTForX(x), this.y1, this.y2);
    }

    private float getTForX(float x) {
        float slope;
        float dist;
        float guessForT;
        float initialSlope;
        int currentSample;
        float intervalStart = 0.0f;
        int lastSample = 10;
        for (currentSample = 1; currentSample != 10 && this.sampleValues[currentSample] <= x; ++currentSample) {
            intervalStart += 0.1f;
        }
        if ((initialSlope = CubicBezier.getSlope(guessForT = intervalStart + (dist = (x - this.sampleValues[--currentSample]) / (slope = this.sampleValues[currentSample + 1] - this.sampleValues[currentSample])) * 0.1f, this.x1, this.x2)) >= 0.001f) {
            return CubicBezier.newtonRaphsonIterate(x, guessForT, this.x1, this.x2);
        }
        if (initialSlope == 0.0f) {
            return guessForT;
        }
        return CubicBezier.binarySubdivide(x, intervalStart, intervalStart + 0.1f, this.x1, this.x2);
    }

    private static float binarySubdivide(float x, float a, float b, float x1, float x2) {
        float currentT;
        float currentX;
        int i = 0;
        do {
            if ((currentX = CubicBezier.calcBezier(currentT = a + (b - a) / 2.0f, x1, x2) - x) > 0.0f) {
                b = currentT;
                continue;
            }
            a = currentT;
        } while (Math.abs(currentX) > 1.0E-7f && (float)(++i) < 10.0f);
        return currentT;
    }

    private static float newtonRaphsonIterate(float x, float guessT, float x1, float x2) {
        int i = 0;
        while ((float)i < 4.0f) {
            float currentSlope = CubicBezier.getSlope(guessT, x1, x2);
            if (currentSlope == 0.0f) {
                return guessT;
            }
            float currentX = CubicBezier.calcBezier(guessT, x1, x2) - x;
            guessT -= currentX / currentSlope;
            ++i;
        }
        return guessT;
    }

    private static float calcBezier(float t, float a1, float a2) {
        return ((CubicBezier.getA(a1, a2) * t + CubicBezier.getB(a1, a2)) * t + CubicBezier.getC(a1)) * t;
    }

    private static float getSlope(float t, float a1, float a2) {
        return 3.0f * CubicBezier.getA(a1, a2) * t * t + 2.0f * CubicBezier.getB(a1, a2) * t + CubicBezier.getC(a1);
    }

    private static float getA(float a1, float a2) {
        return 1.0f - 3.0f * a2 + 3.0f * a1;
    }

    private static float getB(float a1, float a2) {
        return 3.0f * a2 - 6.0f * a1;
    }

    private static float getC(float a1) {
        return 3.0f * a1;
    }

    private static float[] createSampleValues(float x1, float x2) {
        float[] sampleValues = new float[11];
        for (int i = 0; i < 11; ++i) {
            sampleValues[i] = CubicBezier.calcBezier((float)i * 0.1f, x1, x2);
        }
        return sampleValues;
    }
}

