/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.animalbikes.Server;
import noppes.animalbikes.entity.types.EntityRidableFlying;
import noppes.animalbikes.logic.DinoLogic;

public class EntityDinoBike3
extends EntityRidableFlying
implements IEntityAdditionalSpawnData {
    public DinoLogic logic;

    public EntityDinoBike3(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.3f);
        this.canLand = false;
        this.logic = new DinoLogic(this);
        this.flySpeed = 0.81f;
    }

    public EntityDinoBike3(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    public boolean func_70104_M() {
        return this.logic.getGrabbedEntity() == null;
    }

    public void func_70108_f(Entity entity) {
        this.logic.applyEntityCollision(entity);
        super.func_70108_f(entity);
    }

    public void func_70071_h_() {
        EntityAnimal grabbed = this.getGrabbedEntity();
        if (grabbed != null) {
            for (Entity riddenByEntity : this.func_184188_bt()) {
                if (!riddenByEntity.func_70093_af()) continue;
                this.logic.spawnGrabbed();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.logic.compound != null) {
            compound.func_74782_a("AnimalGrabbed", (NBTBase)this.logic.compound);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AnimalGrabbed")) {
            this.logic.compound = compound.func_74775_l("AnimalGrabbed");
        }
    }

    public void func_70106_y() {
        this.logic.spawnGrabbed();
        super.func_70106_y();
    }

    public double func_70042_X() {
        return 0.4;
    }

    public EntityAnimal getGrabbedEntity() {
        return this.logic.getGrabbedEntity();
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70014_b(compound);
        try {
            Server.writeNBT(buffer, compound);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            NBTTagCompound compound = Server.readNBT(additionalData);
            this.func_70037_a(compound);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

