/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.constants.EnumPackets;

public class Server {
    public static boolean sendData(EntityPlayerMP player, EnumPackets enu, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, enu, obs)) {
                return false;
            }
            AnimalBikes.Channel.sendTo(new FMLProxyPacket(buffer, "AnimalBikes"), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void sendAssociatedData(Entity entity, EnumPackets enu, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, enu, obs)) {
                return;
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 60.0);
            AnimalBikes.Channel.sendToAllAround(new FMLProxyPacket(buffer, "AnimalBikes"), point);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendToAll(EnumPackets enu, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, enu, obs)) {
                return;
            }
            AnimalBikes.Channel.sendToAll(new FMLProxyPacket(buffer, "AnimalBikes"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean fillBuffer(ByteBuf buffer, Enum enu, Object ... obs) throws IOException {
        buffer.writeInt(enu.ordinal());
        for (Object ob : obs) {
            if (ob == null) continue;
            if (ob instanceof Map) {
                Map map = (Map)ob;
                buffer.writeInt(map.size());
                for (String key : map.keySet()) {
                    int value = (Integer)map.get(key);
                    buffer.writeInt(value);
                    Server.writeString(buffer, key);
                }
                continue;
            }
            if (ob instanceof List) {
                List list = (List)ob;
                buffer.writeInt(list.size());
                for (String s : list) {
                    Server.writeString(buffer, s);
                }
                continue;
            }
            if (ob instanceof Enum) {
                buffer.writeInt(((Enum)ob).ordinal());
                continue;
            }
            if (ob instanceof Integer) {
                buffer.writeInt(((Integer)ob).intValue());
                continue;
            }
            if (ob instanceof Boolean) {
                buffer.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (ob instanceof String) {
                Server.writeString(buffer, (String)ob);
                continue;
            }
            if (ob instanceof Float) {
                buffer.writeFloat(((Float)ob).floatValue());
                continue;
            }
            if (ob instanceof Long) {
                buffer.writeLong(((Long)ob).longValue());
                continue;
            }
            if (ob instanceof Double) {
                buffer.writeDouble(((Double)ob).doubleValue());
                continue;
            }
            if (!(ob instanceof NBTTagCompound)) continue;
            Server.writeNBT(buffer, (NBTTagCompound)ob);
        }
        if (buffer.array().length >= Short.MAX_VALUE) {
            System.err.println("Packet " + enu + " was too big to be send");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNBT(ByteBuf buffer, NBTTagCompound compound) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)compound, (DataOutput)dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
        byte[] bytes = bytearrayoutputstream.toByteArray();
        buffer.writeShort((int)((short)bytes.length));
        buffer.writeBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound readNBT(ByteBuf buffer) throws IOException {
        byte[] bytes = new byte[buffer.readShort()];
        buffer.readBytes(bytes);
        DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))));
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_152456_a((DataInput)datainputstream, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            return nBTTagCompound;
        }
        finally {
            datainputstream.close();
        }
    }

    public static void writeString(ByteBuf buffer, String s) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        buffer.writeShort((int)((short)bytes.length));
        buffer.writeBytes(bytes);
    }

    public static String readString(ByteBuf buffer) {
        try {
            byte[] bytes = new byte[buffer.readShort()];
            buffer.readBytes(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static void doExplosion(World world, Explosion explosion, float size) {
        if (world.field_72995_K) {
            return;
        }
        for (Object ob : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)ob;
            Vec3d vec = explosion.getPosition();
            SPacketExplosion packet = new SPacketExplosion(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, size, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(player));
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }
}

