/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.AnimalBikesPermissions;
import noppes.animalbikes.entity.EntityPonyBike;
import noppes.animalbikes.entity.EntityPonyFlyingBike;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.items.ItemAnimalBike;

public class ItemPonyBike
extends ItemAnimalBike {
    public static final List<String> textures = new ArrayList<String>();
    public static final List<String> dyablePonies = new ArrayList<String>();

    @Override
    public EntityRidable getBike(World world) {
        int rand = world.field_73012_v.nextInt(textures.size());
        byte b = ItemPonyBike.getType(rand);
        if (b == 2 || b == 3) {
            EntityPonyFlyingBike pony = new EntityPonyFlyingBike(world);
            pony.setType(b);
            pony.setColor(rand);
            return pony;
        }
        EntityPonyBike pony = new EntityPonyBike(world);
        pony.setType(b);
        pony.setColor(rand);
        return pony;
    }

    public static byte getType(int index) {
        String texture = textures.get(index);
        if (texture.startsWith("animalbikes:textures/entity/ponies/alicorn")) {
            return 3;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/pegasus")) {
            return 2;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/unicorn")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return !AnimalBikes.DisablePony && AnimalBikesPermissions.hasPermission(player, "animalbikes.pony.use");
    }

    @Override
    public boolean isBike(EntityRidable entity) {
        return EntityPonyBike.class.isInstance((Object)entity) || EntityPonyFlyingBike.class.isInstance((Object)entity);
    }

    static {
        if (textures.isEmpty()) {
            textures.add("animalbikes:textures/entity/ponies/alicorn/minelp princess celestia.png");
            textures.add("animalbikes:textures/entity/ponies/alicorn/minelp princess luna s2.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp aloe.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp apple bloom.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp applejack.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp berry punch.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp big mac.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp bon bon.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp caramel.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Carrot Top.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Cheerilee.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Cherry.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Doctor Whooves.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Golden Harvest.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Lotus.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Nurse Redheart.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Octavia.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Pinkie Pie.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp Roseluck.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Blueberry Muffin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Brolly.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Cherries Jubilee.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Cloud Kicker.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Derpy Hooves.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Endless Clouds.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Fluttershy.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Orange Box.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Pegasus Guard.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Rainbow Dash.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Raindrop.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Roy G Bow.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Scootaloo.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Soarin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Spitfire.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Under D Weather.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp Velvet Hooves.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Chocolate Sun.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Colgate.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Crescent.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp DJ Pon3.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Heartstrings.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Holly Dash.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Lemon Hearts.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Lemon Tart.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Lyra.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp North Pole.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Orchid Dew.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Rarity.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Sparkler.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Star Sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Sweetie Belle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Trixie.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Twilight Sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp Unicorn Guard.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/minelp Princess Luna S2.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp Big Mac.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp Lyra.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp Chocolate Sun.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp Rainbow Dash.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp Rarity.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp Heartstrings.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp Derpy Hooves.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp Octavia.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp Pinkie Pie.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp Under D Weather.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp Fluttershy.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp DJ Pon3.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp Twilight Sparkle.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp Applejack.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/minelp Princess Celestia.png");
        }
    }
}

