/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.Server;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntityCreeperBike
extends EntityRidable {
    private static final DataParameter<Boolean> DW_EXPLODING = EntityDataManager.func_187226_a(EntityCreeperBike.class, (DataSerializer)DataSerializers.field_187198_h);
    int timeSinceIgnited = 0;
    int lastActiveTime;

    public EntityCreeperBike(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.8f);
    }

    public EntityCreeperBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_EXPLODING, (Object)false);
    }

    @Override
    public Item getWheel() {
        return ABItems.creeper;
    }

    public void func_70071_h_() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.isExploding()) {
            if (this.timeSinceIgnited == 5) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187572_ar, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited == 30) {
                this.explosion();
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                super.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    private void explosion() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        float power = 2.0f;
        if (this.getPowered()) {
            power = 6.0f;
        }
        boolean terrainDamage = this.func_184102_h().func_71218_a(0).func_82736_K().func_82766_b("animalbikesTerrainDamage");
        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, false, terrainDamage);
        explosion.func_77278_a();
        if (!terrainDamage) {
            explosion.func_180342_d();
        }
        explosion.func_77279_a(true);
        Server.doExplosion(this.field_70170_p, explosion, power);
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (!this.field_70170_p.field_72995_K && !this.isExploding() && i > 0.0f && this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.field_70180_af.func_187227_b(DW_EXPLODING, (Object)true);
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, 16.0);
            if (entity != null) {
                // empty if block
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    public void func_70106_y() {
        if (!this.isExploding()) {
            super.func_70106_y();
        }
    }

    public double func_70042_X() {
        return 0.4;
    }

    public boolean getPowered() {
        return this.isSpecial();
    }

    public void func_70077_a(EntityLightningBolt entitylightningbolt) {
        super.func_70077_a(entitylightningbolt);
        this.setIsSpecial(true);
    }

    public boolean isExploding() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_EXPLODING);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float getCreeperFlashTime(float f) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * f) / 28.0f;
    }
}

