/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.entity.EntityPonyFlyingBike;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.items.ItemPonyBike;

public class EntityPonyBike
extends EntityRidable {
    private static final DataParameter<Byte> DW_TYPE = EntityDataManager.func_187226_a(EntityPonyBike.class, (DataSerializer)DataSerializers.field_187191_a);
    int prevX = 0;
    int prevZ = 0;
    private BlockPos lastPos = BlockPos.field_177992_a;

    public EntityPonyBike(World world) {
        super(world);
        this.func_70105_a(0.7f, 1.3f);
    }

    public EntityPonyBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TYPE, (Object)0);
    }

    @Override
    public Item getWheel() {
        return ABItems.pony;
    }

    public byte getType() {
        return (Byte)this.field_70180_af.func_187225_a(DW_TYPE);
    }

    public void setType(byte type) {
        this.field_70180_af.func_187227_b(DW_TYPE, (Object)type);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("PonyType", this.getType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74771_c("PonyType"));
    }

    public boolean standingOnAir() {
        return !this.field_70122_E;
    }

    public double func_70042_X() {
        return 1.0;
    }

    public boolean func_70093_af() {
        for (Entity riddenByEntity : this.func_184188_bt()) {
            if (!(riddenByEntity instanceof EntityPlayer)) continue;
            return riddenByEntity.func_70093_af();
        }
        return super.func_70093_af();
    }

    @Override
    public void func_70636_d() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean activate = (this.prevZ != z || this.prevX != x) && this.func_184207_aI();
        byte type = this.getType();
        if (activate && (type == 0 || type == 3)) {
            this.earthPony();
        }
        if (activate && (type == 1 || type == 3)) {
            this.unicornPony();
        }
        this.prevX = x;
        this.prevZ = z;
        super.func_70636_d();
    }

    private void unicornPony() {
        if (!this.func_70093_af() && this.field_70170_p.field_72995_K) {
            AnimalBikes.proxy.spawnParticles("rainbow", (EntityLiving)this);
        }
    }

    private void earthPony() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos pos = new BlockPos((Entity)this);
        if (this.lastPos.equals((Object)pos)) {
            return;
        }
        BlockPos pos2 = pos.func_177977_b();
        Block block = this.field_70170_p.func_180495_p(pos2).func_177230_c();
        if (block == Blocks.field_150346_d) {
            this.field_70170_p.func_180501_a(pos2, Blocks.field_150349_c.func_176223_P(), 2);
        } else if (block == Blocks.field_150349_c && this.field_70170_p.func_175623_d(pos)) {
            int rand = this.field_70170_p.field_73012_v.nextInt(25);
            if (rand == 0) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150328_O.func_176223_P(), 2);
            }
            if (rand == 12) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150327_N.func_176223_P(), 2);
            }
        }
        this.lastPos = pos;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (item == null || !(item.func_77973_b() instanceof ItemDye) || this.field_70170_p.field_72995_K) {
            return super.func_184645_a(player, hand);
        }
        int i = item.func_77952_i();
        String tex = ItemPonyBike.dyablePonies.get(i);
        if (!ItemPonyBike.textures.contains(tex)) {
            return false;
        }
        int color = ItemPonyBike.textures.indexOf(tex);
        if (this.getColor() == color) {
            return false;
        }
        byte ntype = ItemPonyBike.getType(color);
        byte ctype = this.getType();
        if (ctype < 2 && ntype >= 2) {
            EntityPonyFlyingBike bike = new EntityPonyFlyingBike(this.field_70170_p);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_189511_e(compound);
            bike.func_70020_e(compound);
            bike.setColor(color);
            bike.setType(ntype);
            this.field_70128_L = true;
            this.field_70170_p.func_72838_d((Entity)bike);
        } else if (ctype >= 2 && ntype < 2) {
            EntityPonyBike bike = new EntityPonyBike(this.field_70170_p);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_189511_e(compound);
            bike.func_70020_e(compound);
            bike.setColor(color);
            bike.setType(ntype);
            this.field_70128_L = true;
            this.field_70170_p.func_72838_d((Entity)bike);
        } else {
            this.setColor(color);
            this.setType(ntype);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        }
        return true;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }
}

