/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.animalbikes.ABEntities;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.logic.DinoLogic;

public class EntityDinoBike
extends EntityRidable
implements IEntityAdditionalSpawnData {
    private static final DataParameter<NBTTagCompound> DW_GRABBED = EntityDataManager.func_187226_a(EntityDinoBike.class, (DataSerializer)DataSerializers.field_192734_n);
    public DinoLogic logic = new DinoLogic(this, DW_GRABBED);

    public EntityDinoBike(World world) {
        super(ABEntities.DinoBike, world);
    }

    public EntityDinoBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityDinoBike(EntityType type, World world) {
        super(type, world);
        this.func_70105_a(0.9f, 1.5f);
        this.canColor = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_GRABBED, (Object)new NBTTagCompound());
    }

    @Override
    public boolean func_70104_M() {
        return this.logic.getGrabbedEntity() == null;
    }

    public void func_70108_f(Entity entity) {
        this.logic.applyEntityCollision(entity);
        super.func_70108_f(entity);
    }

    @Override
    public Item getWheel() {
        return ABItems.dino;
    }

    public void func_70071_h_() {
        EntityAnimal grabbed = this.getGrabbedEntity();
        if (grabbed != null) {
            for (Entity riddenByEntity : this.func_184188_bt()) {
                if (!riddenByEntity.func_70093_af()) continue;
                this.logic.spawnGrabbed();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("AnimalGrabbed", (INBTBase)this.logic.getCompound());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.logic.setCompound(compound.func_74775_l("AnimalGrabbed"));
    }

    public void func_70106_y() {
        this.logic.spawnGrabbed();
        super.func_70106_y();
    }

    public double func_70042_X() {
        return 0.9;
    }

    public EntityAnimal getGrabbedEntity() {
        return this.logic.getGrabbedEntity();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70014_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }
}

