/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.logic;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.entity.types.EntityRidable;

public class DinoLogic {
    private final DataParameter<NBTTagCompound> DW_GRABBED;
    private long lastGrabbed = 0L;
    private EntityAnimal entity;
    private EntityRidable bike;

    public DinoLogic(EntityRidable bike, DataParameter<NBTTagCompound> DW_GRABBED) {
        this.bike = bike;
        this.DW_GRABBED = DW_GRABBED;
    }

    public void applyEntityCollision(Entity entity) {
        if (entity == this.bike.rider) {
            return;
        }
        if (!this.bike.field_70170_p.field_72995_K && this.bike.rider != null && this.getCompound().isEmpty() && entity instanceof EntityAnimal && this.lastGrabbed + 2000L < System.currentTimeMillis()) {
            EntityAnimal grabbed = (EntityAnimal)entity;
            NBTTagCompound compound = new NBTTagCompound();
            grabbed.func_70039_c(compound);
            this.setCompound(compound);
            entity = grabbed;
            grabbed.field_70128_L = true;
        }
    }

    public void spawnGrabbed() {
        if (!this.bike.field_70170_p.field_72995_K && !this.getCompound().isEmpty()) {
            Entity animal = EntityType.func_200716_a((NBTTagCompound)this.getCompound(), (World)this.bike.field_70170_p);
            if (animal == null) {
                return;
            }
            double dx = -MathHelper.func_76126_a((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            double dz = MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            animal.func_70107_b(this.bike.field_70165_t + dx, this.bike.field_70163_u, this.bike.field_70161_v + dz);
            this.bike.field_70170_p.func_72838_d(animal);
        }
        this.setCompound(new NBTTagCompound());
        this.entity = null;
        this.lastGrabbed = System.currentTimeMillis();
    }

    public NBTTagCompound getCompound() {
        return (NBTTagCompound)this.bike.func_184212_Q().func_187225_a(this.DW_GRABBED);
    }

    public void setCompound(NBTTagCompound compound) {
        this.bike.func_184212_Q().func_187227_b(this.DW_GRABBED, (Object)compound);
    }

    public EntityAnimal getGrabbedEntity() {
        if (this.getCompound().isEmpty()) {
            return null;
        }
        if (this.entity != null) {
            return this.entity;
        }
        this.entity = (EntityAnimal)EntityType.func_200716_a((NBTTagCompound)this.getCompound(), (World)this.bike.field_70170_p);
        return this.entity;
    }
}

