/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import noppes.animalbikes.client.layer.LayerDragonDeath;
import noppes.animalbikes.client.layer.LayerDragonEyes;
import noppes.animalbikes.client.model.ModelDragonBike;
import noppes.animalbikes.client.renderer.RenderAnimalBike;
import noppes.animalbikes.entity.EntityDragonBike;

public class RenderDragonBike
extends LivingRenderer<EntityDragonBike, ModelDragonBike<EntityDragonBike>> {
    private static final ResourceLocation resource = new ResourceLocation("textures/entity/enderdragon/dragon.png");

    public RenderDragonBike(EntityRendererManager manager) {
        super(manager, new ModelDragonBike(0.0f), 0.5f);
        this.func_177094_a(new LayerDragonDeath((IEntityRenderer<EntityDragonBike, ModelDragonBike<EntityDragonBike>>)this));
        this.func_177094_a(new LayerDragonEyes((IEntityRenderer<EntityDragonBike, ModelDragonBike<EntityDragonBike>>)this));
    }

    protected void preRenderCallback(EntityDragonBike bike, float f) {
        if (bike.isSpecial()) {
            GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        } else {
            GlStateManager.scalef((float)0.4f, (float)0.4f, (float)0.4f);
        }
    }

    protected void applyRotations(EntityDragonBike bike, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        float f3 = (float)bike.getMovementOffsets(7, p_77043_4_)[0];
        float f4 = (float)(bike.getMovementOffsets(5, p_77043_4_)[1] - bike.getMovementOffsets(10, p_77043_4_)[1]);
        GlStateManager.rotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f4 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)1.0f);
    }

    protected void renderModel(EntityDragonBike entity, float f, float f2, float f3, float f4, float f5, float f6) {
        this.func_180548_c((Entity)entity);
        ((ModelDragonBike)this.func_217764_d()).render(entity, f, f2, f3, f4, f5, f6);
        if (entity.field_70737_aN <= 0) {
            return;
        }
        GlStateManager.depthFunc((int)514);
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        ((ModelDragonBike)this.func_217764_d()).render(entity, f, f2, f3, f4, f5, f6);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.depthFunc((int)515);
    }

    protected ResourceLocation getEntityTexture(EntityDragonBike entity) {
        return resource;
    }

    public void doRender(EntityDragonBike entity, double x, double y, double z, float f, float partialTicks) {
        float[] color = RenderAnimalBike.colorTable[entity.getColor() % 16];
        GlStateManager.color3f((float)color[0], (float)color[1], (float)color[2]);
        super.func_76986_a((LivingEntity)entity, x, y, z, f, partialTicks);
    }

    protected boolean canRenderName(EntityDragonBike entity) {
        return super.func_177070_b((LivingEntity)entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }
}

