/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.util.ResourceLocation;
import noppes.animalbikes.client.layer.LayerSlimeBike;
import noppes.animalbikes.client.model.ModelMagma;
import noppes.animalbikes.client.renderer.RenderAnimalBike;
import noppes.animalbikes.entity.EntitySlimeBike;

public class RenderSlimeBike
extends RenderAnimalBike<EntitySlimeBike, EntityModel<EntitySlimeBike>> {
    private static final ResourceLocation slimeTextures = new ResourceLocation("animalbikes:textures/entity/slime.png");
    private static final ResourceLocation magmaCubeTextures = new ResourceLocation("textures/entity/slime/magmacube.png");
    private EntityModel slime;
    private EntityModel magma;

    public RenderSlimeBike(EntityRendererManager manager) {
        super(manager, new SlimeModel(16), 0.25f);
        this.slime = this.field_77045_g;
        this.magma = new ModelMagma();
        this.func_177094_a(new LayerSlimeBike((IEntityRenderer<EntitySlimeBike, EntityModel<EntitySlimeBike>>)this));
    }

    protected void preRenderCallback(EntitySlimeBike bike, float par2) {
        if (!bike.isSpecial()) {
            float f1 = 2.0f;
            float f2 = (bike.prevSquishFactor + (bike.squishFactor - bike.prevSquishFactor) * par2) / (f1 * 0.5f + 1.0f);
            float f3 = 1.0f / (f2 + 1.0f);
            bike.offset = 1.0f / f3;
            GlStateManager.scalef((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
        } else {
            float f1 = (bike.prevSquishFactor + (bike.squishFactor - bike.prevSquishFactor) * par2) / 2.0f;
            float f2 = 1.0f / (f1 + 1.0f);
            float f3 = 2.0f;
            GlStateManager.scalef((float)(f2 * f3), (float)2.0f, (float)(f2 * f3));
        }
    }

    protected ResourceLocation getEntityTexture(EntitySlimeBike entity) {
        return entity.isSpecial() ? magmaCubeTextures : slimeTextures;
    }

    @Override
    public void doRender(EntitySlimeBike entity, double d, double d1, double d2, float f, float f1) {
        this.field_77045_g = entity.isSpecial() ? this.magma : this.slime;
        entity.canColor = !entity.isSpecial();
        super.doRender(entity, d, d1, d2, f, f1);
    }
}

